/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.audio.utils;

import ch.tachyon.tunnel.common.AudioStreamFormat;
import javax.sound.sampled.AudioFormat;

public class FormatUtils {
    public static AudioStreamFormat toStreamFormat(AudioFormat format) {
        int precision = format.getSampleSizeInBits();
        if (precision == -1) {
            precision = 32;
        }
        AudioStreamFormat sFormat = new AudioStreamFormat(format.getSampleRate(), format.getChannels(), precision);
        sFormat.setAudioFormat(format);
        return sFormat;
    }

    public static AudioFormat fromStreamFormat(AudioStreamFormat sFormat) {
        if (sFormat.getAudioFormat() instanceof AudioFormat) {
            return (AudioFormat)sFormat.getAudioFormat();
        }
        return new AudioFormat(AudioFormat.Encoding.PCM_FLOAT, (float)sFormat.getSampleRate(), sFormat.getQuantization(), sFormat.getChannels(), (sFormat.getQuantization() + 7) / 8 * sFormat.getChannels(), (float)sFormat.getSampleRate(), false);
    }
}

