/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.audio.utils;

import ch.tachyon.tunnel.audio.utils.CodecInputStream;
import ch.tachyon.tunnel.common.utils.Utils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.Charset;
import java.util.Properties;

public class IOUtils {
    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException ex) {
            if (Utils.isBelowJava18()) {
                throw new RuntimeException(ex);
            }
            try {
                Class<?> clazz = Class.forName("java.io.UncheckedIOException");
                Constructor<?> cons = clazz.getConstructor(IOException.class);
                RuntimeException rex = (RuntimeException)cons.newInstance(ex);
                throw rex;
            }
            catch (ClassNotFoundException ex2) {
                throw new RuntimeException(ex);
            }
            catch (SecurityException ex1) {
                throw new RuntimeException(ex);
            }
            catch (NoSuchMethodException ex1) {
                throw new RuntimeException(ex);
            }
            catch (IllegalArgumentException ex1) {
                throw new RuntimeException(ex);
            }
            catch (InstantiationException ex1) {
                throw new RuntimeException(ex);
            }
            catch (IllegalAccessException ex1) {
                throw new RuntimeException(ex);
            }
            catch (InvocationTargetException ex1) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void close(Object c) {
        if (c instanceof Closeable) {
            IOUtils.close((Closeable)c);
        }
    }

    public static void loadUtf8Properties(InputStream input, Properties properties) throws IOException {
        CodecInputStream codec = new CodecInputStream(input, Charset.forName("UTF-8"), Charset.forName("ISO-8859-1"));
        properties.load(codec);
    }
}

