/*
 * Decompiled with CFR 0.152.
 */
package ch.tachyon.tunnel.common.utils;

import ch.tachyon.tunnel.common.utils.Debug;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Utils {
    public static final String NEW_LINE = System.getProperty("line.separator");
    private static int javaMajorVersion;
    private static int javaMinorVersion;

    static {
        String javaVersion = System.getProperty("java.version");
        try {
            String[] tokens = javaVersion.split("\\.");
            if (tokens.length == 1) {
                int value = Integer.parseInt(Utils.keepDigitsOnly(tokens[0]));
                if (value >= 11) {
                    javaMajorVersion = value;
                    javaMinorVersion = 0;
                } else {
                    javaMajorVersion = 1;
                    javaMinorVersion = value;
                }
            } else {
                javaMajorVersion = Integer.parseInt(Utils.keepDigitsOnly(tokens[0]));
                javaMinorVersion = Integer.parseInt(Utils.keepDigitsOnly(tokens[1]));
            }
        }
        catch (Exception ex) {
            Debug.error(ex);
        }
    }

    private static String keepDigitsOnly(String text) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch >= '0' && ch <= '9') {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static boolean eq(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    public static int hashCode(Object obj) {
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public static byte[] toByteArray(Object obj) {
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oo = new ObjectOutputStream(bo);
            oo.writeObject(obj);
            oo.flush();
            return bo.toByteArray();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static <E> E fromByteArray(byte[] data, Class<E> type) {
        Object result;
        block7: {
            block6: {
                if (data == null) {
                    return null;
                }
                ByteArrayInputStream bi = new ByteArrayInputStream(data);
                ObjectInputStream oi = new ObjectInputStream(bi);
                result = oi.readObject();
                if (result != null) break block6;
                return null;
            }
            if (type.isInstance(result)) break block7;
            return null;
        }
        try {
            return (E)result;
        }
        catch (IOException ex) {
            Debug.error(ex);
        }
        catch (ClassNotFoundException ex) {
            Debug.error(ex);
        }
        return null;
    }

    public static boolean isBelowJava16() {
        return javaMajorVersion <= 1 && javaMinorVersion < 6;
    }

    public static boolean isBelowJava17() {
        return javaMajorVersion <= 1 && javaMinorVersion < 7;
    }

    public static boolean isBelowJava18() {
        return javaMajorVersion <= 1 && javaMinorVersion < 8;
    }

    public static boolean isBelowJava19() {
        return javaMajorVersion <= 1 && javaMinorVersion < 9;
    }

    public static boolean isBelowJava11() {
        return javaMajorVersion < 11;
    }
}

