/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.audio.device;

import ch.tachyon.tunnel.common.utils.Debug;
import org.corebounce.common.audio.device.AudioException;
import org.corebounce.common.audio.device.IAudioDevice;
import org.corebounce.common.audio.device.JavaSoundDevice;

public class AudioIO {
    private int playDeviceNum = 0;
    private int nbPlayChans = 0;
    private int recordDeviceNum = 0;
    private int nbRecordChans = 0;
    private int rate = 0;
    private int nbFrames = 0;
    private int nbBuffers = 0;
    private IAudioDevice device = null;
    private boolean isInitialized = false;
    private float[] buffer = null;
    private static AudioIO instance = null;

    private AudioIO() {
    }

    public static synchronized AudioIO instance() {
        if (instance == null) {
            instance = new AudioIO();
        }
        return instance;
    }

    private IAudioDevice getDevice() {
        if (this.device == null) {
            this.device = new JavaSoundDevice();
        }
        this.isInitialized = false;
        return this.device;
    }

    private IAudioDevice getDevice0() {
        if (this.device != null) {
            return this.device;
        }
        return this.getDevice();
    }

    public synchronized int preferredFrameSize() {
        return this.getDevice0().preferredFrameSize();
    }

    public synchronized int preferredNumberOfBuffers() {
        return this.getDevice0().preferredNumberOfBuffers();
    }

    private void flush() {
        if (this.nbPlayChans == 0 && this.nbRecordChans == 0) {
            this.nbFrames = 0;
            this.nbBuffers = 0;
            this.rate = 0;
            if (this.device != null) {
                try {
                    this.device.setup(0, 0, 0, 0, 0, 0, 0);
                }
                catch (AudioException ex) {
                    Debug.error("Failed to close audio device: {0}", ex);
                }
                Thread.currentThread().setPriority(5);
                this.device = null;
            }
        }
    }

    public synchronized boolean isRecording() {
        return this.nbRecordChans > 0;
    }

    public synchronized boolean isPlaying() {
        return this.nbPlayChans > 0;
    }

    public synchronized void requestPlayBack(int deviceNum, int nbChans, int rate, int nbFrames, int nbBuffers) throws AudioException {
        if (this.nbPlayChans > 0) {
            return;
        }
        if (nbFrames < 0) {
            nbFrames = this.getDevice().preferredFrameSize();
        }
        if (nbBuffers < 0) {
            nbBuffers = this.getDevice().preferredNumberOfBuffers();
        }
        if (this.nbFrames != 0 && this.nbFrames != nbFrames) {
            throw new AudioException("Capture buffer size {0} != Playback buffer size {1}", this.nbFrames, nbFrames);
        }
        if (this.nbBuffers != 0 && this.nbBuffers != nbBuffers) {
            throw new AudioException("Capture buffers {0} != Playback buffers {1}", this.nbBuffers, nbBuffers);
        }
        if (this.rate != 0 && this.rate != rate) {
            throw new AudioException("Capture rate {0} != Playback rate {1}", this.rate, rate);
        }
        this.playDeviceNum = deviceNum;
        this.nbPlayChans = nbChans;
        this.nbFrames = nbFrames;
        this.nbBuffers = nbBuffers;
        this.rate = rate;
        Debug.debug("Request playback {0} {1} {2} {3}", deviceNum, nbChans, rate, nbFrames);
        if (this.getDevice() == null) {
            throw new AudioException("Cannot open audio playback {0} {1} {2}", nbChans, rate, nbFrames);
        }
    }

    public synchronized void requestCapture(int deviceNum, int nbChans, int rate, int nbFrames, int nbBuffers) throws AudioException {
        if (this.nbRecordChans > 0) {
            return;
        }
        if (nbFrames < 0) {
            nbFrames = this.getDevice().preferredFrameSize();
        }
        if (nbBuffers < 0) {
            nbBuffers = this.getDevice().preferredNumberOfBuffers();
        }
        if (this.nbFrames != 0 && this.nbFrames != nbFrames) {
            throw new AudioException("Capture buffer size {1} != Playback buffer size {0}", this.nbFrames, nbFrames);
        }
        if (this.nbBuffers != 0 && this.nbBuffers != nbBuffers) {
            throw new AudioException("Capture buffers {1} != Playback buffers {0}", this.nbBuffers, nbBuffers);
        }
        if (this.rate != 0 && this.rate != rate) {
            throw new AudioException("Capture rate {1} != Playback rate {0}", this.rate, rate);
        }
        this.recordDeviceNum = deviceNum;
        this.nbRecordChans = nbChans;
        this.nbFrames = nbFrames;
        this.nbBuffers = nbBuffers;
        this.rate = rate;
        Debug.debug("Request capture {0} {1} {2} {3}", deviceNum, nbChans, rate, nbFrames);
        if (this.getDevice() == null) {
            throw new AudioException("Cannot open audio capture {0} {1} {2}", nbChans, rate, nbFrames);
        }
    }

    private void setup() throws AudioException {
        if (this.nbRecordChans != 0 || this.nbPlayChans != 0) {
            Thread.currentThread().setPriority(10);
        }
        this.device.setup(this.recordDeviceNum, this.nbRecordChans, this.playDeviceNum, this.nbPlayChans, this.rate, this.nbFrames, this.nbBuffers);
        this.buffer = new float[this.nbFrames * Math.max(this.nbPlayChans, this.nbRecordChans)];
        this.isInitialized = true;
    }

    public synchronized boolean record(float[] samples, int offset, int count) throws AudioException {
        if (!this.isInitialized) {
            this.setup();
        }
        return this.device.recordBuffer(samples, offset, count);
    }

    public synchronized boolean record(float[][] target) throws AudioException {
        if (!this.isInitialized) {
            this.setup();
        }
        boolean result = this.device.recordBuffer(this.buffer, 0, this.nbFrames * this.nbRecordChans);
        int chan = 0;
        while (chan < this.nbRecordChans) {
            int i = 0;
            while (i < this.nbFrames) {
                target[chan][i] = this.buffer[i * this.nbRecordChans + chan];
                ++i;
            }
            ++chan;
        }
        return result;
    }

    public synchronized boolean play(float[] samples, int offset, int count) throws AudioException {
        if (!this.isInitialized) {
            this.setup();
        }
        return this.device.playBuffer(samples, offset, count);
    }

    public synchronized boolean play(float[][] samples) throws AudioException {
        if (!this.isInitialized) {
            this.setup();
        }
        int chan = 0;
        while (chan < this.nbPlayChans) {
            int i = 0;
            while (i < this.nbFrames) {
                this.buffer[i * this.nbPlayChans + chan] = samples[chan][i];
                ++i;
            }
            ++chan;
        }
        return this.device.playBuffer(this.buffer, 0, this.nbFrames * this.nbPlayChans);
    }

    public synchronized boolean setPaused(boolean paused) throws AudioException {
        if (!this.isInitialized) {
            this.setup();
        }
        return this.device.setPaused(paused);
    }

    public synchronized int getPlayBufferSize() {
        if (this.nbPlayChans <= 0) {
            return -1;
        }
        if (!this.isInitialized) {
            return 0;
        }
        return this.device.getPlayBufferSize() / this.nbPlayChans;
    }

    public synchronized int getRecordBufferSize() {
        if (this.nbRecordChans <= 0) {
            return -1;
        }
        if (!this.isInitialized) {
            return 0;
        }
        return this.device.getRecordBufferSize() / this.nbRecordChans;
    }

    public synchronized void drain() {
        this.device.drain();
    }

    public synchronized void releasePlayBack() {
        this.playDeviceNum = 0;
        this.nbPlayChans = 0;
        this.flush();
    }

    public synchronized void releaseCapture() {
        this.recordDeviceNum = 0;
        this.nbRecordChans = 0;
        this.flush();
    }
}

