/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.audio.file;

public enum AudioEncodingType {
    ENC_8BIT_S(1){

        @Override
        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)source[srcIndex++] / 128.0f;
                ++i;
            }
        }

        @Override
        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 128.0f, -128.0f, 127.0f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)source[i];
                ++i;
            }
        }
    }
    ,
    ENC_8BIT_U(1){

        @Override
        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)((byte)(source[srcIndex++] + 128)) / 128.0f;
                ++i;
            }
        }

        @Override
        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 128.0f, -128.0f, 127.0f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((byte)source[i] + 128);
                ++i;
            }
        }
    }
    ,
    ENC_16BIT_LE(2){

        @Override
        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)(source[srcIndex++] & 0xFF | source[srcIndex++] << 8) / 32768.0f;
                ++i;
            }
        }

        @Override
        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 32768.0f, -32768.0f, 32767.0f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((int)source[i] & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 8 & 0xFF);
                ++i;
            }
        }
    }
    ,
    ENC_16BIT_BE(2){

        @Override
        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)(source[srcIndex++] << 8 | source[srcIndex++] & 0xFF) / 32768.0f;
                ++i;
            }
        }

        @Override
        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 32768.0f, -32768.0f, 32767.0f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((int)source[i] >> 8 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] & 0xFF);
                ++i;
            }
        }
    }
    ,
    ENC_24BIT_LE(3){

        @Override
        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)(source[srcIndex++] & 0xFF | (source[srcIndex++] & 0xFF) << 8 | source[srcIndex++] << 16) / 8388608.0f;
                ++i;
            }
        }

        @Override
        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 8388608.0f, -8388608.0f, 8388607.0f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((int)source[i] & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 8 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 16 & 0xFF);
                ++i;
            }
        }
    }
    ,
    ENC_24BIT_BE(3){

        @Override
        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)(source[srcIndex++] << 16 | (source[srcIndex++] & 0xFF) << 8 | source[srcIndex++] & 0xFF) / 8388608.0f;
                ++i;
            }
        }

        @Override
        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 8388608.0f, -8388608.0f, 8388607.0f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((int)source[i] >> 16 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 8 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] & 0xFF);
                ++i;
            }
        }
    }
    ,
    ENC_32BIT_LE(4){

        @Override
        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)(source[srcIndex++] & 0xFF | (source[srcIndex++] & 0xFF) << 8 | (source[srcIndex++] & 0xFF) << 16 | source[srcIndex++] << 24) / 2.1474836E9f;
                ++i;
            }
        }

        @Override
        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 2.1474836E9f, -2.1474836E9f, 2.1474836E9f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((int)source[i] & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 8 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 16 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 24 & 0xFF);
                ++i;
            }
        }
    }
    ,
    ENC_32BIT_BE(4){

        @Override
        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                target[i] = (float)(source[srcIndex++] << 24 | (source[srcIndex++] & 0xFF) << 16 | (source[srcIndex++] & 0xFF) << 8 | source[srcIndex++] & 0xFF) / 2.1474836E9f;
                ++i;
            }
        }

        @Override
        public void encode(float[] source, byte[] target, int length) {
            AudioEncodingType.mulAndCrop(source, 2.1474836E9f, -2.1474836E9f, 2.1474836E9f, length);
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                target[dstIndex++] = (byte)((int)source[i] >> 24 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 16 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] >> 8 & 0xFF);
                target[dstIndex++] = (byte)((int)source[i] & 0xFF);
                ++i;
            }
        }
    }
    ,
    ENC_FLOAT_LE(4){

        @Override
        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                int value = source[srcIndex++] & 0xFF | (source[srcIndex++] & 0xFF) << 8 | (source[srcIndex++] & 0xFF) << 16 | source[srcIndex++] << 24;
                target[i] = Float.intBitsToFloat(value);
                ++i;
            }
        }

        @Override
        public void encode(float[] source, byte[] target, int length) {
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                int value = Float.floatToIntBits(source[i]);
                target[dstIndex++] = (byte)(value & 0xFF);
                target[dstIndex++] = (byte)(value >> 8 & 0xFF);
                target[dstIndex++] = (byte)(value >> 16 & 0xFF);
                target[dstIndex++] = (byte)(value >> 24 & 0xFF);
                ++i;
            }
        }
    }
    ,
    ENC_FLOAT_BE(4){

        @Override
        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                int value = source[srcIndex++] << 24 | (source[srcIndex++] & 0xFF) << 16 | (source[srcIndex++] & 0xFF) << 8 | source[srcIndex++] & 0xFF;
                target[i] = Float.intBitsToFloat(value);
                ++i;
            }
        }

        @Override
        public void encode(float[] source, byte[] target, int length) {
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                int value = Float.floatToIntBits(source[i]);
                target[dstIndex++] = (byte)(value >> 24 & 0xFF);
                target[dstIndex++] = (byte)(value >> 16 & 0xFF);
                target[dstIndex++] = (byte)(value >> 8 & 0xFF);
                target[dstIndex++] = (byte)(value & 0xFF);
                ++i;
            }
        }
    }
    ,
    ENC_DOUBLE_LE(8){

        @Override
        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                long value = (long)source[srcIndex++] & 0xFFL | ((long)source[srcIndex++] & 0xFFL) << 8 | ((long)source[srcIndex++] & 0xFFL) << 16 | ((long)source[srcIndex++] & 0xFFL) << 24 | ((long)source[srcIndex++] & 0xFFL) << 32 | ((long)source[srcIndex++] & 0xFFL) << 40 | ((long)source[srcIndex++] & 0xFFL) << 48 | (long)source[srcIndex++] << 56;
                target[i] = (float)Double.longBitsToDouble(value);
                ++i;
            }
        }

        @Override
        public void encode(float[] source, byte[] target, int length) {
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                long value = Double.doubleToLongBits(source[i]);
                target[dstIndex++] = (byte)(value & 0xFFL);
                target[dstIndex++] = (byte)(value >> 8 & 0xFFL);
                target[dstIndex++] = (byte)(value >> 16 & 0xFFL);
                target[dstIndex++] = (byte)(value >> 24 & 0xFFL);
                target[dstIndex++] = (byte)(value >> 32 & 0xFFL);
                target[dstIndex++] = (byte)(value >> 40 & 0xFFL);
                target[dstIndex++] = (byte)(value >> 48 & 0xFFL);
                target[dstIndex++] = (byte)(value >> 56 & 0xFFL);
                ++i;
            }
        }
    }
    ,
    ENC_DOUBLE_BE(8){

        @Override
        public void decode(byte[] source, float[] target, int length) {
            int srcIndex = 0;
            int i = 0;
            while (i < length) {
                long value = (long)source[srcIndex++] << 56 | ((long)source[srcIndex++] & 0xFFL) << 48 | ((long)source[srcIndex++] & 0xFFL) << 40 | ((long)source[srcIndex++] & 0xFFL) << 32 | ((long)source[srcIndex++] & 0xFFL) << 24 | ((long)source[srcIndex++] & 0xFFL) << 16 | ((long)source[srcIndex++] & 0xFFL) << 8 | (long)source[srcIndex++] & 0xFFL;
                target[i] = (float)Double.longBitsToDouble(value);
                ++i;
            }
        }

        @Override
        public void encode(float[] source, byte[] target, int length) {
            int dstIndex = 0;
            int i = 0;
            while (i < length) {
                long value = Double.doubleToLongBits(source[i]);
                target[dstIndex++] = (byte)(value >> 56 & 0xFFL);
                target[dstIndex++] = (byte)(value >> 48 & 0xFFL);
                target[dstIndex++] = (byte)(value >> 40 & 0xFFL);
                target[dstIndex++] = (byte)(value >> 32 & 0xFFL);
                target[dstIndex++] = (byte)(value >> 24 & 0xFFL);
                target[dstIndex++] = (byte)(value >> 16 & 0xFFL);
                target[dstIndex++] = (byte)(value >> 8 & 0xFFL);
                target[dstIndex++] = (byte)(value & 0xFFL);
                ++i;
            }
        }
    };

    private final int bytesPerSample;

    private AudioEncodingType(int bytesPerSample) {
        this.bytesPerSample = bytesPerSample;
    }

    public int getBytesPerSample() {
        return this.bytesPerSample;
    }

    public abstract void decode(byte[] var1, float[] var2, int var3);

    public abstract void encode(float[] var1, byte[] var2, int var3);

    private static void mulAndCrop(float[] source, float mult, float min, float max, int length) {
        int i = 0;
        while (i < length) {
            float s = source[i] * mult;
            source[i] = s < min ? min : (s > max ? max : s);
            ++i;
        }
    }

    /* synthetic */ AudioEncodingType(String string, int n, int n2, AudioEncodingType audioEncodingType) {
        this(n2);
    }
}

