/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.audio.file;

import ch.tachyon.tunnel.common.AudioStreamFormat;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import ch.tachyon.tunnel.common.utils.Monitor;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import javax.sound.sampled.AudioFileFormat;
import org.corebounce.common.audio.file.AudioFileIO;
import org.corebounce.common.audio.file.FloatQueue;

public class SimpleAudioFileWriter
implements Closeable {
    private final OutputStream target;
    private final AudioFileFormat format;
    private final int nbChans;
    private final IMultiChanAudioSource source;
    private final FloatQueue[] queues;
    private final Object lock = new Monitor("AudioFileWriter");
    private boolean eof = false;

    public SimpleAudioFileWriter(OutputStream target, AudioFileFormat format, int queueCapacity) {
        this.target = target;
        this.format = format;
        this.nbChans = format.getFormat().getChannels();
        this.queues = new FloatQueue[this.nbChans];
        int chan = 0;
        while (chan < this.nbChans) {
            this.queues[chan] = new FloatQueue(queueCapacity);
            ++chan;
        }
        this.source = new AudioSource();
        Thread thread = new Thread(this::save, "saveThread");
        thread.start();
    }

    private void save() {
        try {
            AudioFileIO.saveAudioFile(this.source, this.format.getFrameLength(), this.target, this.format, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(float[][] data) {
        int amount = data[0].length;
        Object object = this.lock;
        synchronized (object) {
            while (this.queues[0].getSize() + amount > this.queues[0].getCapacity()) {
                try {
                    this.lock.wait();
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
            }
            int chan = 0;
            while (chan < this.nbChans) {
                this.queues[chan].pushArray(data[chan]);
                ++chan;
            }
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.eof = true;
            this.lock.notify();
        }
    }

    class AudioSource
    implements IMultiChanAudioSource {
        AudioSource() {
        }

        @Override
        public AudioStreamFormat getAudioFormat() {
            return new AudioStreamFormat(SimpleAudioFileWriter.this.format.getFormat().getSampleRate(), SimpleAudioFileWriter.this.format.getFormat().getChannels(), SimpleAudioFileWriter.this.format.getFormat().getSampleSizeInBits());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int readSamples(float[][] target) {
            int requested = target[0].length;
            int nbChans = target.length;
            Object object = SimpleAudioFileWriter.this.lock;
            synchronized (object) {
                while (!SimpleAudioFileWriter.this.eof && SimpleAudioFileWriter.this.queues[0].getSize() < requested) {
                    try {
                        SimpleAudioFileWriter.this.lock.wait();
                    }
                    catch (InterruptedException ex) {
                        throw new RuntimeException(ex);
                    }
                }
                int amount = Math.min(requested, SimpleAudioFileWriter.this.queues[0].getSize());
                int chan = 0;
                while (chan < nbChans) {
                    SimpleAudioFileWriter.this.queues[chan].popArray(target[chan], 0, amount);
                    ++chan;
                }
                SimpleAudioFileWriter.this.lock.notify();
                return amount;
            }
        }

        @Override
        public void close() {
        }
    }
}

