/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp;

import org.corebounce.common.dsp.AverageBuffer;
import org.corebounce.common.dsp.IMovingFilter;

public class GaussianFilter
implements IMovingFilter {
    private final int numSections;
    private final AverageBuffer[] avgBuffers;

    public GaussianFilter(int size, int numSections) {
        this.numSections = numSections;
        this.avgBuffers = new AverageBuffer[numSections];
        int i = 0;
        while (i < numSections) {
            this.avgBuffers[i] = new AverageBuffer(size);
            ++i;
        }
    }

    @Override
    public void push(float value) {
        AverageBuffer[] averageBufferArray = this.avgBuffers;
        int n = this.avgBuffers.length;
        int n2 = 0;
        while (n2 < n) {
            AverageBuffer ab = averageBufferArray[n2];
            ab.push(value);
            value = ab.getFiltered();
            ++n2;
        }
    }

    @Override
    public float getFiltered() {
        return this.avgBuffers[this.numSections - 1].getFiltered();
    }

    @Override
    public void decSize() {
        AverageBuffer[] averageBufferArray = this.avgBuffers;
        int n = this.avgBuffers.length;
        int n2 = 0;
        while (n2 < n) {
            AverageBuffer ab = averageBufferArray[n2];
            ab.decSize();
            ++n2;
        }
    }

    @Override
    public int getSize() {
        return this.avgBuffers[0].getSize();
    }

    @Override
    public float getLatency() {
        float result = 0.0f;
        AverageBuffer[] averageBufferArray = this.avgBuffers;
        int n = this.avgBuffers.length;
        int n2 = 0;
        while (n2 < n) {
            AverageBuffer section = averageBufferArray[n2];
            result += section.getLatency();
            ++n2;
        }
        return result;
    }

    @Override
    public void resetTo(float value) {
        AverageBuffer[] averageBufferArray = this.avgBuffers;
        int n = this.avgBuffers.length;
        int n2 = 0;
        while (n2 < n) {
            AverageBuffer ab = averageBufferArray[n2];
            ab.resetTo(value);
            ++n2;
        }
    }
}

