/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp;

import java.util.Arrays;
import org.corebounce.common.dsp.IMovingFilter;

public class MaxBuffer
implements IMovingFilter {
    private int size;
    private float[] values;
    private int index;
    private float max;

    public MaxBuffer(int size, float initValues) {
        this.size = size;
        this.values = new float[size];
        this.index = 0;
        Arrays.fill(this.values, initValues);
        this.max = initValues;
    }

    @Override
    public void push(float value) {
        float old = this.values[this.index];
        this.values[this.index] = value;
        ++this.index;
        if (this.index >= this.size) {
            this.index = 0;
        }
        if (value > this.max) {
            this.max = value;
        } else if (old == this.max && this.values[this.index] != this.max) {
            this.max = this.recalc();
        }
    }

    public void push(double value) {
        this.push((float)value);
    }

    private float recalc() {
        float result = Float.NEGATIVE_INFINITY;
        int i = 0;
        while (i < this.size) {
            if (this.values[i] > result) {
                result = this.values[i];
            }
            ++i;
        }
        return result;
    }

    public void raiseBy(float amount) {
        int i = 0;
        while (i < this.size) {
            int n = i++;
            this.values[n] = this.values[n] + amount;
        }
        this.max += amount;
    }

    public float getMax() {
        return this.max;
    }

    @Override
    public float getFiltered() {
        return this.getMax();
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public float getLatency() {
        return ((float)this.size - 1.0f) / 2.0f;
    }

    public void setSize(int size) {
        if (size == this.size) {
            return;
        }
        float[] old = this.values;
        this.size = size;
        this.values = new float[size];
        int min = size < old.length ? size : old.length;
        int offset = size - min;
        int i = 0;
        while (i < min) {
            this.values[i + offset] = old[(this.index + i) % old.length];
            ++i;
        }
        if (size < old.length) {
            this.max = this.recalc();
        }
        this.index = 0;
    }

    @Override
    public void decSize() {
        this.setSize(this.size - 1);
    }

    @Override
    public void resetTo(float value) {
        Arrays.fill(this.values, value);
        this.max = value;
        this.index = 0;
    }
}

