/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp;

import org.corebounce.common.dsp.IMovingFilter;
import org.corebounce.common.dsp.MaxBuffer;
import org.corebounce.common.dsp.MinBuffer;

public class RangeBuffer
implements IMovingFilter {
    private final MinBuffer minBuffer;
    private final MaxBuffer maxBuffer;

    public RangeBuffer(int size, float initValues) {
        this.minBuffer = new MinBuffer(size, initValues);
        this.maxBuffer = new MaxBuffer(size, initValues);
    }

    @Override
    public void push(float value) {
        this.minBuffer.push(value);
        this.maxBuffer.push(value);
    }

    @Override
    public float getFiltered() {
        return (this.minBuffer.getMin() + this.maxBuffer.getMax()) / 2.0f;
    }

    @Override
    public void decSize() {
        this.minBuffer.decSize();
        this.maxBuffer.decSize();
    }

    @Override
    public int getSize() {
        return this.minBuffer.getSize();
    }

    @Override
    public float getLatency() {
        return this.minBuffer.getLatency();
    }

    @Override
    public void resetTo(float value) {
        this.minBuffer.resetTo(value);
        this.maxBuffer.resetTo(value);
    }
}

