/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.fft;

import java.awt.Color;
import java.util.Arrays;
import org.corebounce.common.audio.AudioMath;
import org.corebounce.common.dsp.fft.BooFFT;
import org.corebounce.common.dsp.fft.Windows;
import org.corebounce.common.math.Cmplx;
import org.corebounce.common.utils.Plotter;

public class UltrasphericalWindows {
    private static double gegenbauer(int index, double alpha, double arg) {
        if (index < 0) {
            throw new IllegalArgumentException();
        }
        if (index == 0) {
            return 1.0;
        }
        if (index == 1) {
            return 2.0 * alpha * arg;
        }
        if ((float)alpha == 0.0f) {
            return UltrasphericalWindows.chebyshev(index, arg);
        }
        double prev2 = 0.0;
        double prev1 = 1.0;
        double result = 2.0 * alpha * arg;
        int i = 2;
        while (i <= index) {
            prev2 = prev1;
            prev1 = result;
            double n = i;
            result = (2.0 * arg * (n + alpha - 1.0) * prev1 - (n + 2.0 * alpha - 2.0) * prev2) / n;
            ++i;
        }
        return result;
    }

    private static double chebyshev(int index, double arg) {
        double prev2 = 0.0;
        double prev1 = 1.0;
        double result = arg;
        int i = 2;
        while (i <= index) {
            prev2 = prev1;
            prev1 = result;
            result = 2.0 * arg * prev1 - prev2;
            ++i;
        }
        return result;
    }

    public static double getXu(double attenuationDb, double u, int size) {
        double y;
        if (size % 2 == 0) {
            ++size;
        }
        int middle = (size - 1) / 2;
        double r = Math.pow(10.0, attenuationDb / 20.0);
        double x0 = Math.cosh(UltrasphericalWindows.acosh(r) / (double)(size - 1));
        if ((float)u == 0.0f) {
            return x0;
        }
        double py = y = Math.cos(Math.PI / (4.0 * (double)middle));
        int iter = 0;
        do {
            if ((float)(py = y) != (float)(y -= UltrasphericalWindows.gegenbauer(2 * middle, u, y) / (2.0 * u * UltrasphericalWindows.gegenbauer(2 * middle - 1, u + 1.0, y)))) continue;
            ++iter;
        } while (iter < 5);
        return x0 * y / Math.cos(Math.PI / (4.0 * (double)middle));
    }

    private static double acosh(double arg) {
        return Math.log(arg + Math.sqrt(arg * arg - 1.0));
    }

    public static void fillWindow(float[] window, double xu, double u) {
        int size = window.length;
        if (size % 2 == 0) {
            ++size;
        }
        int middle = (size - 1) / 2;
        assert (middle * 2 + 1 == size);
        double gbm1 = UltrasphericalWindows.gegenbauer(size - 1, u, xu);
        double[] polynomials = new double[middle];
        int k = 1;
        while (k <= middle) {
            double p;
            polynomials[k - 1] = p = UltrasphericalWindows.gegenbauer(size - 1, u, xu * Math.cos((double)k * Math.PI / (double)size));
            ++k;
        }
        double w0 = UltrasphericalWindows.windowCoeff(xu, size, middle, gbm1, 0, polynomials);
        int i = -middle;
        while (i < middle) {
            double value = UltrasphericalWindows.windowCoeff(xu, size, middle, gbm1, i, polynomials);
            window[i + middle] = (float)(value / w0);
            ++i;
        }
    }

    private static double windowCoeff(double xu, int size, int middle, double gbm1, int i, double[] polynomials) {
        double value = gbm1;
        int k = 1;
        while (k <= middle) {
            value += 2.0 * polynomials[k - 1] * Math.cos(2.0 * (double)i * Math.PI * (double)k / (double)size);
            ++k;
        }
        return value /= (double)size;
    }

    public static void fillWindow(float[] window, double xu, double u, BooFFT fft) {
        if (u < -1.5 || u > 20.0) {
            throw new IllegalArgumentException("u must be >= -1.5 and <= 20.0");
        }
        int length = window.length;
        if (fft == null) {
            fft = new BooFFT(length / 2);
        }
        Cmplx[] coeffs = new Cmplx[length / 2 + 1];
        int i = 0;
        while (i < coeffs.length) {
            double coeff = UltrasphericalWindows.gegenbauer(length, u, xu * Math.cos(Math.PI * (double)i / (double)length));
            coeffs[i] = new Cmplx((float)coeff, 0.0f);
            ++i;
        }
        float[] uswt = new float[window.length];
        fft.backC2R(coeffs, uswt);
        float w0 = uswt[0];
        int i2 = 0;
        while (i2 < length) {
            window[i2] = uswt[(i2 + length / 2) % length] / w0;
            ++i2;
        }
    }

    public static float[] buildDbResponse(int Size, float[] window, int PAD) {
        int ZLength = Size * PAD;
        int offset = (ZLength - Size) / 2;
        float[] zeroPadded = new float[ZLength];
        int i = 0;
        while (i < Size) {
            zeroPadded[i + offset] = window[i];
            ++i;
        }
        BooFFT fft = new BooFFT(ZLength / 2);
        Cmplx[] spectrum = Cmplx.newArray(ZLength / 2 + 1);
        fft.forwR2C(zeroPadded, spectrum);
        int showAmount = PAD * 24;
        showAmount = PAD * 44;
        float[] dbResponse = new float[showAmount];
        int i2 = 0;
        while (i2 < showAmount) {
            dbResponse[i2] = (float)AudioMath.levelToDb(spectrum[i2].mag());
            ++i2;
        }
        i2 = showAmount - 1;
        while (i2 >= 0) {
            int n = i2--;
            dbResponse[n] = dbResponse[n] - dbResponse[0];
        }
        return dbResponse;
    }

    public static void main(String[] args) {
        UltrasphericalWindows.plot4410();
    }

    static void plot4096() {
        int Size = 4096;
        double u = 3.1;
        double xu = UltrasphericalWindows.getXu(43.0, 3.1, 4096);
        System.out.println(xu);
        float[] window = new float[4096];
        UltrasphericalWindows.fillWindow(window, xu, 3.1, new BooFFT(2048));
        float[] hann = new float[4096];
        Windows.fillHannWindow(hann);
        float[] hamming = new float[4096];
        Windows.fillHammingWindow(hamming);
        float[] blackmann = new float[4096];
        Windows.fillBlackmanWindow(blackmann);
        float[] kaiser = new float[4096];
        Windows.fillKaiserWindow(kaiser, 4096, 58.0);
        float[] cheb = new float[4096];
        UltrasphericalWindows.fillWindow(cheb, UltrasphericalWindows.getXu(46.7, 0.0, 4096), 0.0, new BooFFT(4096));
        float[] triangular = new float[4096];
        Windows.fillTriangularWindow(triangular, 4096);
        float[] gaussian = new float[4096];
        Windows.fillGaussianWindow(gaussian, 4096, 0.46f);
        float[] nutall = new float[4096];
        Windows.fillNutallWindow(nutall);
        float[] flattop = new float[4096];
        Windows.fillFlatTopWindow(flattop);
        int PAD = 32;
        Plotter p2 = new Plotter(1.0f, -130.0f, 0.0f, 32.0f, 10.0f, true, "Response");
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, hann, 32), Color.RED);
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, hamming, 32), Color.BLUE);
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, blackmann, 32), Color.GREEN);
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, kaiser, 32), Color.CYAN.darker());
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, cheb, 32), Color.PINK);
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, triangular, 32), new Color(255, 128, 0));
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, gaussian, 32), Color.GRAY);
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, nutall, 32), Color.MAGENTA);
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, flattop, 32), Color.YELLOW);
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, window, 32), Color.BLACK);
        float ratio = 0.9287982f;
        p2.addPoint(320.0f * ratio, -55.0f, Color.RED);
        p2.addPoint(640.0f * ratio, -82.0f, Color.RED);
        p2.addPoint(960.0f * ratio, -109.0f, Color.RED);
        p2.addPoint(240.0f * ratio, -55.0f, new Color(0, 128, 0));
        p2.addPoint(496.0f * ratio, -82.0f, new Color(0, 128, 0));
        p2.addPoint(800.0f * ratio, -109.0f, new Color(0, 128, 0));
        p2.addPoint(360.0f * ratio, -55.0f, new Color(221, 119, 21));
        p2.addPoint(800.0f * ratio, -82.0f, new Color(221, 119, 21));
        p2.addPoint(1360.0f * ratio, -109.0f, new Color(221, 119, 21));
        float lineX = 59.443085f;
        p2.addLine(lineX, 0.0f, lineX, -130.0f, Color.gray);
        p2.addLine(32.0f, -28.0f, 1408.0f, -28.0f, Color.GRAY);
        p2.show();
    }

    static void plot4410() {
        int Size = 4096;
        double u = 2.0;
        double xu = UltrasphericalWindows.getXu(70.0, 2.0, 4096);
        System.out.println(xu);
        float[] window = new float[4096];
        UltrasphericalWindows.fillWindow(window, xu, 2.0, null);
        float[] hann = new float[4096];
        Windows.fillHannWindow(hann);
        float[] hamming = new float[4096];
        Windows.fillHammingWindow(hamming);
        float[] blackmann = new float[4096];
        Windows.fillBlackmanWindow(blackmann);
        float[] kaiser = new float[4096];
        Windows.fillKaiserWindow(kaiser, 4096, Windows.getKaiserBeta(85.0));
        float[] cheb = new float[4096];
        Windows.fillChebyshevWindow(cheb, 85.0, null);
        float[] triangular = new float[4096];
        Windows.fillTriangularWindow(triangular, 4096);
        float[] gaussian = new float[4096];
        Windows.fillGaussianWindow(gaussian, 4096, 0.46f);
        float[] nutall = new float[4096];
        Windows.fillNutallWindow(nutall);
        float[] flattop = new float[4096];
        Windows.fillFlatTopWindow(flattop);
        float[] rect = new float[4096];
        Arrays.fill(rect, 0.5f);
        int PAD = 32;
        Plotter plotter = new Plotter(4096.0f, -0.1f, 1.15f, 0.1f, 0.1f, false, "Window");
        plotter.addCurve(hann, Color.RED);
        plotter.addCurve(hamming, Color.BLUE);
        plotter.addCurve(blackmann, Color.GREEN);
        plotter.addCurve(kaiser, Color.CYAN.darker());
        plotter.addCurve(cheb, Color.PINK);
        plotter.addCurve(triangular, new Color(255, 128, 0));
        plotter.addCurve(gaussian, Color.GRAY);
        plotter.addCurve(nutall, Color.MAGENTA);
        plotter.addCurve(flattop, Color.YELLOW.darker());
        plotter.addCurve(window, Color.BLACK);
        plotter.show();
        Plotter p2 = new Plotter(1.0f, -120.0f, 0.0f, 32.0f, 10.0f, true, "Response");
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, hann, 32), Color.RED);
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, hamming, 32), Color.BLUE);
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, blackmann, 32), Color.GREEN);
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, kaiser, 32), Color.CYAN.darker());
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, cheb, 32), Color.PINK);
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, triangular, 32), new Color(255, 128, 0));
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, gaussian, 32), Color.GRAY);
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, nutall, 32), Color.MAGENTA);
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, flattop, 32), Color.YELLOW.darker());
        p2.addCurve(UltrasphericalWindows.buildDbResponse(4096, window, 32), Color.BLACK);
        p2.addPoint(320.0f, -55.0f, Color.RED);
        p2.addPoint(640.0f, -82.0f, Color.RED);
        p2.addPoint(960.0f, -109.0f, Color.RED);
        p2.addPoint(160.0f, -55.0f, Color.BLUE);
        p2.addPoint(320.0f, -82.0f, Color.BLUE);
        p2.addPoint(480.0f, -109.0f, Color.BLUE);
        p2.addPoint(240.0f, -55.0f, new Color(0, 128, 0));
        p2.addPoint(496.0f, -82.0f, new Color(0, 128, 0));
        p2.addPoint(800.0f, -109.0f, new Color(0, 128, 0));
        p2.addPoint(360.0f, -55.0f, new Color(221, 119, 21));
        p2.addPoint(800.0f, -82.0f, new Color(221, 119, 21));
        p2.addPoint(1360.0f, -109.0f, new Color(221, 119, 21));
        p2.addLine(32.0f, -28.0f, 1408.0f, -28.0f, Color.GRAY);
        p2.show();
    }
}

