/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.dsp.resample.FastSincLiConvolvedAudioSource;
import org.corebounce.common.dsp.resample.IAudioSource;
import org.corebounce.common.dsp.resample.IResampler;
import org.corebounce.common.dsp.resample.ISubSampleDelay;

public class FastSincResampler
implements IResampler,
ISubSampleDelay {
    private static final Boolean OLD_MODE = null;
    private final FastSincLiConvolvedAudioSource source;
    private final double ratio;
    private final int latency;
    private double subSampleDelay;

    public FastSincResampler(IAudioSource source, double sampleRate, double ratio, double nbSamplesPerZeroCross, int nbZeroCross, float antiAliasing, int bufferSize, boolean oldMode) {
        if (nbZeroCross < 1) {
            throw new IllegalArgumentException();
        }
        if (OLD_MODE != null) {
            oldMode = OLD_MODE;
        }
        if (oldMode) {
            while (ratio * (double)nbZeroCross < 3.0) {
                ++nbZeroCross;
            }
        } else if (ratio < 1.0) {
            double minValue;
            nbZeroCross = (int)Math.ceil((double)nbZeroCross / ratio);
            if ((nbSamplesPerZeroCross *= ratio) < (minValue = Math.sqrt(nbSamplesPerZeroCross))) {
                nbSamplesPerZeroCross = minValue;
            }
        }
        float amplitudeCorrection = (float)Math.min(ratio, 1.0);
        float sincStretch = 1.0f / amplitudeCorrection;
        double srcStep = 1.0 / ratio;
        this.ratio = ratio;
        this.source = new FastSincLiConvolvedAudioSource(source, nbSamplesPerZeroCross, nbZeroCross, sincStretch, bufferSize, srcStep, amplitudeCorrection);
        this.latency = nbZeroCross;
    }

    @Override
    public void setSubSampleDelay(double delay) {
        this.subSampleDelay = delay;
        this.source.setSubSampleDelay(delay);
    }

    @Override
    public void reset() {
        this.source.reset();
    }

    @Override
    public int resample(float[] output) {
        return this.source.getSamples(output, 0, output.length);
    }

    @Override
    public double getLatency() {
        return (double)this.latency + this.subSampleDelay / this.ratio;
    }
}

