/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.dsp.resample.IAudioSource;
import org.corebounce.common.dsp.resample.IResampler;
import org.corebounce.common.dsp.resample.SincConvolvedAudioSource;
import org.corebounce.common.math.Fraction;

public class PolyphaseResampler
implements IResampler {
    private final SincConvolvedAudioSource source;
    private final int latency;

    /*
     * Unable to fully structure code
     */
    public PolyphaseResampler(IAudioSource source, Fraction ratio, int nbZeroCross, float antiAliasing, int bufferSize) {
        super();
        if (nbZeroCross >= 1) ** GOTO lbl5
        throw new IllegalArgumentException();
lbl-1000:
        // 1 sources

        {
            ++nbZeroCross;
lbl5:
            // 2 sources

            ** while (ratio.doubleValue() * (double)nbZeroCross < 3.0)
        }
lbl6:
        // 1 sources

        amplitudeCorrection = Math.min(ratio.floatValue(), 1.0f);
        if (!ratio.equals(1L) && (double)antiAliasing != 0.0) {
            amplitudeCorrection = (float)((double)amplitudeCorrection * (1.0 - (double)antiAliasing + (double)(antiAliasing * PolyphaseResampler.getBandWidth(nbZeroCross))));
        }
        sincStretch = 1.0f / amplitudeCorrection;
        this.source = new SincConvolvedAudioSource(source, Fraction.inverse(ratio), nbZeroCross, bufferSize, sincStretch, amplitudeCorrection);
        this.latency = nbZeroCross;
    }

    @Override
    public void reset() {
        this.source.reset();
    }

    @Override
    public int resample(float[] output) {
        return this.source.getSamples(output, 0, output.length);
    }

    static float getBandWidth(int nbZeroCross) {
        float rollOff = 1.0f / ((float)nbZeroCross / 2.0f + 1.0f);
        return 1.0f - rollOff;
    }

    @Override
    public double getLatency() {
        return this.latency;
    }
}

