/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.dsp.resample.LinearInterpolatedBuffer;

public class SincLiBuffer
extends LinearInterpolatedBuffer {
    private final float scaleFactor;

    public SincLiBuffer(double nbSamplesPerZeroCross, int nbZeroCross, float stretch) {
        super(SincLiBuffer.ceil(nbSamplesPerZeroCross) * nbZeroCross + SincLiBuffer.ceil(nbSamplesPerZeroCross) / 2 + 2);
        this.scaleFactor = (float)nbSamplesPerZeroCross / (float)Math.PI;
        this.fillData(nbSamplesPerZeroCross, nbZeroCross, stretch);
    }

    private static int ceil(double value) {
        return (int)Math.ceil(value);
    }

    private void fillData(double samplesPerZeroCross, int nbZeroCross, float stretch) {
        int i = 0;
        while (i < super.getSize()) {
            double angle = (double)i / samplesPerZeroCross;
            double phase = (double)i / (samplesPerZeroCross * (double)nbZeroCross * 2.0);
            float hann = this.hann(0.5 - phase);
            float value = this.sinc(angle / (double)stretch) * hann;
            super.set(i, value);
            ++i;
        }
    }

    private float hann(double angle) {
        if (angle < 0.0 || angle > 1.0) {
            return 0.0f;
        }
        double x = Math.PI * 2 * angle;
        double val = 0.5 - 0.5 * Math.cos(x);
        return (float)val;
    }

    SincLiBuffer(double nbSamplesPerZeroCross, int nbZeroCross) {
        super(SincLiBuffer.ceil(nbSamplesPerZeroCross) * nbZeroCross + SincLiBuffer.ceil(nbSamplesPerZeroCross) / 2 + 2);
        this.scaleFactor = (float)(nbSamplesPerZeroCross / Math.PI);
        int i = 0;
        while (i < super.getSize()) {
            float angle = (float)i / (float)nbSamplesPerZeroCross;
            super.set(i, this.sinc(angle));
            ++i;
        }
    }

    private float sinc(double angle) {
        if (angle == 0.0) {
            return 1.0f;
        }
        return (float)(Math.sin(Math.PI * angle) / (Math.PI * angle));
    }

    @Override
    public float get(float angle) {
        float index = angle * this.scaleFactor;
        if (index < 0.0f) {
            return super.get(-index);
        }
        return super.get(index);
    }

    public float getPreScaled(float angle) {
        return super.get(angle);
    }

    @Override
    public float get(int index) {
        if (index < 0) {
            return super.get(-index);
        }
        return super.get(index);
    }

    public float getPos(int index) {
        return super.get(index);
    }

    public float getScaleFactor() {
        return this.scaleFactor;
    }

    public static void main(String[] args) {
        SincLiBuffer buffer = new SincLiBuffer(64.0, 4, 1.5f);
        int a = 0;
        while (a < buffer.getSize()) {
            float value = buffer.get(a);
            int k = (int)((value + 1.0f) * 60.0f + 0.5f);
            int i = 30;
            while (i <= 120) {
                if (i == k) {
                    System.out.print("*");
                } else if (i == 60) {
                    System.out.print("|");
                } else {
                    System.out.print(" ");
                }
                ++i;
            }
            System.out.println(String.valueOf(a) + ":" + value);
            ++a;
        }
    }
}

