/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.dsp.resample;

import org.corebounce.common.dsp.resample.LinearInterpolatedBuffer;

public class WindowLiBuffer
extends LinearInterpolatedBuffer {
    private final float scaleFactor;

    public WindowLiBuffer(double nbSamplesPerZeroCross, int nbZeroCross) {
        super(WindowLiBuffer.ceil(nbSamplesPerZeroCross) * nbZeroCross + WindowLiBuffer.ceil(nbSamplesPerZeroCross) / 2 + 2);
        this.scaleFactor = (float)nbSamplesPerZeroCross / (float)Math.PI;
        int i = 0;
        while (i < super.getSize()) {
            double phase = (double)i / (nbSamplesPerZeroCross * (double)nbZeroCross * 2.0);
            float hann = this.hann(0.5 - phase);
            super.set(i, hann);
            ++i;
        }
    }

    private static int ceil(double value) {
        return (int)Math.ceil(value);
    }

    private float hann(double angle) {
        if (angle < 0.0 || angle > 1.0) {
            return 0.0f;
        }
        double x = Math.PI * 2 * angle;
        double val = 0.5 - 0.5 * Math.cos(x);
        return (float)val;
    }

    @Override
    public float get(float angle) {
        float index = angle * this.scaleFactor;
        if (index < 0.0f) {
            return super.get(-index);
        }
        return super.get(index);
    }

    @Override
    public float get(int index) {
        if (index < 0) {
            return super.get(-index);
        }
        return super.get(index);
    }

    public float getPos(int index) {
        return super.get(index);
    }
}

