/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.gui;

import ch.tachyon.tunnel.common.utils.Debug;
import java.awt.AWTKeyStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.TextComponent;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;
import org.corebounce.common.gui.ComboBoxTooltipRenderer;
import org.corebounce.common.gui.ILabelDescription;
import org.corebounce.common.gui.ILafListener;
import org.corebounce.common.gui.TableLayout;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.PlatformType;
import org.corebounce.common.utils.StringUtils;
import org.corebounce.common.utils.ThreadUtils;

public class AwtTools {
    private static Dimension buttonDimension = null;
    private static String lafName = null;
    private static Map<Component, Boolean> detachedComponents = new WeakHashMap<Component, Boolean>();
    private static final Map<ILafListener, Boolean> postLafListeners = new WeakHashMap<ILafListener, Boolean>();

    private AwtTools() {
    }

    public static void init() {
        if (Platform.isUnixLikePlatform()) {
            System.setProperty("awt.useSystemAAFontSettings", "on");
            UIManager.getDefaults().put("Slider.paintValue", (Object)false);
        }
        if (Platform.isMacOsX()) {
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
    }

    public static void setupHighQuality(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    public static void setupHighSpeed(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        g.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
        g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
    }

    public static Color backgroundColor(JComponent cmp) {
        Color result = UIManager.getColor("Panel.background");
        if (result != null) {
            return AwtTools.opacize(result);
        }
        return AwtTools.opacize(cmp.getBackground());
    }

    public static Color foregroundColor(JComponent cmp, String key, Color defaultColor) {
        Color result = UIManager.getColor(key);
        if (result != null) {
            return AwtTools.opacize(result);
        }
        result = cmp.getForeground();
        if (result == null) {
            result = defaultColor;
        }
        return AwtTools.opacize(result);
    }

    public static Color opacize(Color color) {
        int alpha = color.getAlpha();
        if (alpha == 255) {
            return color;
        }
        return new Color(AwtTools.apply(color.getRed(), alpha), AwtTools.apply(color.getGreen(), alpha), AwtTools.apply(color.getBlue(), alpha));
    }

    public static int apply(int value, int alpha) {
        value = 255 - value;
        value = value * alpha / 255;
        value = 255 - value;
        return value;
    }

    public static void centerWindowOnScreen(Window window) {
        GraphicsEnvironment gEnv = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle bounds = gEnv.getMaximumWindowBounds();
        if (window.getWidth() > bounds.width || window.getHeight() > bounds.height) {
            window.setSize(Math.min(window.getWidth(), bounds.width), Math.min(window.getHeight(), bounds.height));
        }
        Point center = gEnv.getCenterPoint();
        Dimension wDim = window.getSize();
        if (wDim.width == 0 && wDim.height == 0) {
            wDim = new Dimension(bounds.width * 2 / 3, bounds.height * 2 / 3);
        }
        int x = center.x - wDim.width / 2;
        int y = center.y - wDim.height / 2;
        window.setLocation(x, y);
    }

    public static void centerWindowOn(Window window, Component parent) {
        window.setLocationRelativeTo(parent);
    }

    public static Point getLocationInWindow(Component cmp) {
        Point location = cmp.getLocation();
        return AwtTools.getLocationInWindow(cmp, location);
    }

    public static Point getLocationInWindow(Component cmp, Point location) {
        Container parent = cmp.getParent();
        while (!(parent instanceof Window)) {
            Point parLocation = parent.getLocation();
            location.setLocation(location.x + parLocation.x, location.y + parLocation.y);
            parent = parent.getParent();
        }
        return location;
    }

    public static Point getLocationIn(Component cmp, Component parent) {
        Point location = cmp.getLocation();
        return AwtTools.getLocationIn(cmp, location, parent);
    }

    public static Point getLocationIn(Component cmp, Point location, Component parent) {
        Container parent0 = cmp.getParent();
        while (parent0 != parent) {
            if (parent0 == null) {
                return null;
            }
            Point parLocation = parent0.getLocation();
            location.setLocation(location.x + parLocation.x, location.y + parLocation.y);
            parent0 = parent0.getParent();
        }
        return location;
    }

    public static int getScreenX(MouseEvent e) {
        return e.getComponent().getLocationOnScreen().x + e.getX();
    }

    public static int getScreenY(MouseEvent e) {
        return e.getComponent().getLocationOnScreen().y + e.getY();
    }

    public static Window getWindow(Component cmp) {
        Component parent = cmp.getParent();
        while (parent != null && !(parent instanceof Window)) {
            if (parent instanceof JPopupMenu && parent.getParent() == null) {
                JPopupMenu menu = (JPopupMenu)parent;
                parent = menu.getInvoker();
                continue;
            }
            parent = parent.getParent();
        }
        return (Window)parent;
    }

    public static Frame getFrame(Component cmp) {
        Container parent = cmp.getParent();
        while (parent != null && !(parent instanceof Frame)) {
            parent = parent.getParent();
        }
        return (Frame)parent;
    }

    public static boolean isWindowsLaf() {
        return UIManager.getLookAndFeel().getName().contains("Windows");
    }

    public static boolean isGtkLaf() {
        return UIManager.getLookAndFeel().getName().contains("GTK");
    }

    public static boolean isAppleLaf() {
        return UIManager.getLookAndFeel().getName().contains("Mac OS");
    }

    public static boolean isFlatLaf() {
        return UIManager.getLookAndFeel().getClass().getName().startsWith("com.formdev.flatlaf");
    }

    public static boolean isNimbusLaf() {
        return UIManager.getLookAndFeel().getName().toLowerCase().contains("nimbus");
    }

    public static boolean isNapkinLaf() {
        return UIManager.getLookAndFeel().getName().toLowerCase().contains("napkin");
    }

    public static void switchToNativeLookAndFeel() {
        if (!Platform.isBelowJava16() && Platform.getPlatform().equals((Object)PlatformType.LINUX)) {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo lafInfo = lookAndFeelInfoArray[n2];
                if (lafInfo.getName().toLowerCase().startsWith("gtk")) {
                    try {
                        AwtTools.setLookAndFeel(lafInfo.getClassName());
                        return;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        try {
            String name = UIManager.getSystemLookAndFeelClassName();
            AwtTools.setLookAndFeel(name);
        }
        catch (Throwable ex) {
            Debug.warn(ex);
        }
    }

    private static void setLookAndFeel(String name) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        if (!SwingUtilities.isEventDispatchThread()) {
            try {
                SwingUtilities.invokeAndWait(() -> {
                    try {
                        AwtTools.setLookAndFeel(name);
                    }
                    catch (Throwable ex) {
                        Debug.error(ex);
                    }
                });
            }
            catch (Exception ex) {
                Debug.error(ex);
            }
            return;
        }
        UIManager.setLookAndFeel(name);
    }

    public static void switchToMetalLookAndFeel() {
        try {
            String name = UIManager.getCrossPlatformLookAndFeelClassName();
            AwtTools.setLookAndFeel(name);
        }
        catch (Throwable ex) {
            Debug.warn(ex);
        }
    }

    public static boolean switchToNimbusLookAndFeel() {
        boolean found = false;
        try {
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            int n = lookAndFeelInfoArray.length;
            int n2 = 0;
            while (n2 < n) {
                UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
                if ("Nimbus".equals(info.getName())) {
                    AwtTools.setLookAndFeel(info.getClassName());
                    found = true;
                    break;
                }
                ++n2;
            }
        }
        catch (Throwable ex) {
            Debug.warn(ex);
        }
        return found;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDetachedComponent(JComponent cmp) {
        Map<Component, Boolean> map = detachedComponents;
        synchronized (map) {
            detachedComponents.put(cmp, Boolean.TRUE);
        }
    }

    public static void cleanupListeners(JComponent cmp) {
        for (MouseListener mouseListener : new ArrayList<MouseListener>(Arrays.asList(cmp.getMouseListeners()))) {
            cmp.removeMouseListener(mouseListener);
        }
        for (MouseMotionListener mouseMotionListener : new ArrayList<MouseMotionListener>(Arrays.asList(cmp.getMouseMotionListeners()))) {
            cmp.removeMouseMotionListener(mouseMotionListener);
        }
        if (cmp instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)cmp;
            for (ActionListener al : new ArrayList<ActionListener>(Arrays.asList(abstractButton.getActionListeners()))) {
                abstractButton.removeActionListener(al);
            }
        }
    }

    public static void cleanupComponents(JComponent cmp) {
        for (Component child : new ArrayList<Component>(Arrays.asList(cmp.getComponents()))) {
            cmp.remove(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPostLafListener(ILafListener listener) {
        Map<ILafListener, Boolean> map = postLafListeners;
        synchronized (map) {
            postLafListeners.put(listener, true);
        }
    }

    public static void switchToLookAndFeel(String lafClassName) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        AwtTools.switchToLookAndFeel(lafClassName, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void switchToLookAndFeel(String lafClassName, boolean updateUI, boolean updateDetachedComponents) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        Map<Object, Boolean> map;
        AwtTools.setLookAndFeel(lafClassName);
        if (updateUI) {
            Frame[] frameArray = Frame.getFrames();
            int n = frameArray.length;
            int n2 = 0;
            while (n2 < n) {
                Frame frame = frameArray[n2];
                if (frame.isDisplayable()) {
                    SwingUtilities.updateComponentTreeUI(frame);
                }
                Window[] windowArray = frame.getOwnedWindows();
                int n3 = windowArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Window window = windowArray[n4];
                    if (window.isDisplayable()) {
                        SwingUtilities.updateComponentTreeUI(window);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if (updateDetachedComponents) {
            map = detachedComponents;
            synchronized (map) {
                boolean success = false;
                while (!success) {
                    try {
                        for (Component cmp : detachedComponents.keySet()) {
                            if (!cmp.isDisplayable()) continue;
                            SwingUtilities.updateComponentTreeUI(cmp);
                            cmp.validate();
                        }
                        success = true;
                    }
                    catch (ConcurrentModificationException ex) {
                        success = false;
                    }
                }
            }
        }
        map = postLafListeners;
        synchronized (map) {
            for (ILafListener listener : new ArrayList<ILafListener>(postLafListeners.keySet())) {
                listener.lookAndFeelChanged(lafClassName);
            }
        }
    }

    public static void invokeAndWait(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    public static void invokeInSwing(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean flushEDT() {
        if (SwingUtilities.isEventDispatchThread()) {
            return false;
        }
        AtomicBoolean flushed = new AtomicBoolean(false);
        Object flushLock = new Object();
        SwingUtilities.invokeLater(() -> {
            Object object2 = flushLock;
            synchronized (object2) {
                flushed.set(true);
                flushLock.notify();
            }
        });
        Object object = flushLock;
        synchronized (object) {
            while (!flushed.get()) {
                ThreadUtils.wait(flushLock);
            }
        }
        return true;
    }

    public static int getScreenRefreshRate() {
        DisplayMode dm;
        GraphicsDevice gd;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (ge != null && (gd = ge.getDefaultScreenDevice()) != null && (dm = gd.getDisplayMode()) != null) {
            return dm.getRefreshRate();
        }
        return 0;
    }

    public static Dimension getDimension(Graphics2D g, String text) {
        TextLayout tl = new TextLayout(text, g.getFont(), g.getFontRenderContext());
        Rectangle2D rect = tl.getBounds();
        return new Dimension((int)(rect.getWidth() + 0.5), (int)(rect.getHeight() + 0.5));
    }

    public static synchronized Dimension getButtonDimension() {
        if (lafName == null || !lafName.equals(UIManager.getLookAndFeel().getName())) {
            buttonDimension = null;
            lafName = UIManager.getLookAndFeel().getName();
        }
        if (buttonDimension == null) {
            String TXT = "X";
            JFrame dummyFrame = new JFrame();
            dummyFrame.getContentPane().setLayout(new BorderLayout());
            JPanel panel = new JPanel();
            dummyFrame.getContentPane().add(panel);
            panel.setLayout(new TableLayout(2));
            int i = 0;
            while (i < 4) {
                JButton button = new JButton("X");
                panel.add(button);
                ++i;
            }
            dummyFrame.pack();
            Dimension buttonsDimension = panel.getSize();
            Dimension txtDimension = AwtTools.getDimension((Graphics2D)dummyFrame.getGraphics(), "X");
            dummyFrame.dispose();
            buttonDimension = new Dimension(buttonsDimension.width / 2 - txtDimension.width, buttonsDimension.height / 2 - txtDimension.height);
        }
        return buttonDimension;
    }

    public static Dimension getButtonDimension(Graphics2D g, String buttonText) {
        Dimension buttonDimension = AwtTools.getButtonDimension();
        Dimension textDimension = AwtTools.getDimension(g, buttonText);
        return new Dimension(buttonDimension.width + textDimension.width, buttonDimension.height + textDimension.height);
    }

    public static Dimension getTypicalDimension(Graphics2D g, int nbTextCols, int nbTextLines, int nbButtonsHorz, int nbButtonsVert) {
        String referenceText = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        Dimension refDimension = AwtTools.getDimension(g, "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz");
        Dimension result = new Dimension(refDimension.width * nbTextCols / "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz".length(), refDimension.height * nbTextLines);
        if (nbButtonsHorz > 0 || nbButtonsVert > 0) {
            Dimension buttonDimension = AwtTools.getButtonDimension();
            result = new Dimension(result.width + buttonDimension.width * nbButtonsHorz, result.height + buttonDimension.height * nbButtonsVert);
        }
        return result;
    }

    public static boolean isContiguousMultiSelect(InputEvent e) {
        int keyMask = 64;
        return (e.getModifiersEx() & keyMask) != 0;
    }

    public static boolean isDiscontiguousMultiSelect(InputEvent e) {
        int keyMask = Platform.isMacOsX() ? 256 : 128;
        return (e.getModifiersEx() & keyMask) != 0;
    }

    public static boolean isMultiSelect(InputEvent e) {
        return AwtTools.isContiguousMultiSelect(e) || AwtTools.isDiscontiguousMultiSelect(e);
    }

    public static Action wrapShortcutKeyAction(final Action target) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component cmp;
                Window window;
                Component focused;
                Object source = e.getSource();
                if (source instanceof Component && ((focused = (window = AwtTools.getWindow(cmp = (Component)source)).getFocusOwner()) instanceof JTextComponent || focused instanceof TextComponent)) {
                    return;
                }
                target.actionPerformed(e);
            }
        };
    }

    private static Action wrapShortcutKeyAction(final ActionListener actionListener, final boolean excludeTextInputComponent) {
        return new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component cmp;
                Window window;
                Component focused;
                Object source;
                if (excludeTextInputComponent && (source = e.getSource()) instanceof Component && ((focused = (window = AwtTools.getWindow(cmp = (Component)source)).getFocusOwner()) instanceof JTextComponent || focused instanceof TextComponent)) {
                    return;
                }
                actionListener.actionPerformed(e);
            }
        };
    }

    public static void addKeyboardShortcut(AbstractButton button, KeyStroke keyStroke) {
        if (button.getAction() == null) {
            throw new IllegalArgumentException("The button must have an action");
        }
        Object actionKey = new Object();
        button.getInputMap(2).put(keyStroke, actionKey);
        button.getActionMap().put(actionKey, AwtTools.wrapShortcutKeyAction(button.getAction()));
    }

    public static void addKeyboardShortcut(AbstractButton button, int keyCode) {
        AwtTools.addKeyboardShortcut(button, KeyStroke.getKeyStroke(keyCode, 0));
    }

    public static void addKeyboardShortcut(JComponent button, KeyStroke keyStroke, Action action) {
        Object actionKey = new Object();
        button.getInputMap(2).put(keyStroke, actionKey);
        button.getActionMap().put(actionKey, AwtTools.wrapShortcutKeyAction(action));
    }

    public static void addKeyboardShortcut(JComponent cmp, int when, KeyStroke keyStroke, final Runnable action) {
        AwtTools.addKeyboardShortcut(cmp, when, keyStroke, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                action.run();
            }
        });
    }

    public static void addKeyboardShortcut(JComponent button, int when, KeyStroke keyStroke, Action action) {
        Object actionKey = new Object();
        button.getInputMap(when).put(keyStroke, actionKey);
        button.getActionMap().put(actionKey, action);
    }

    public static void addKeyboardShortcut(JComponent button, ActionListener listener, KeyStroke keyStroke) {
        AwtTools.addKeyboardShortcut(button, listener, keyStroke, true);
    }

    public static void addKeyboardShortcut(JComponent button, ActionListener listener, KeyStroke keyStroke, boolean excludeTextInputComponent) {
        Object actionKey = new Object();
        button.getInputMap(2).put(keyStroke, actionKey);
        button.getActionMap().put(actionKey, AwtTools.wrapShortcutKeyAction(listener, excludeTextInputComponent));
    }

    public static void addKeyboardShortcut(JComponent button, ActionListener listener, int keyCode) {
        AwtTools.addKeyboardShortcut(button, listener, KeyStroke.getKeyStroke(keyCode, 0));
    }

    public static void addKeyboardShortcut(JComponent button, ActionListener listener, int keyCode, boolean excludeTextInputComponent) {
        AwtTools.addKeyboardShortcut(button, listener, KeyStroke.getKeyStroke(keyCode, 0), excludeTextInputComponent);
    }

    public static int showOptionDialog(Component parent, String message, String title, int messageType, int optionType, Icon icon, String[] options0, String defaultOption) {
        boolean reverse;
        Object[] options = options0;
        boolean bl = reverse = Platform.isUnixLikePlatform() && !AwtTools.isGtkLaf() && !AwtTools.isNimbusLaf();
        if (reverse) {
            options = Arrays.copyOf(options0, options0.length);
            Collections.reverse(Arrays.asList(options));
        }
        int option = JOptionPane.showOptionDialog(parent, message, title, messageType, optionType, icon, options, defaultOption);
        if (reverse) {
            option = options.length - 1 - option;
        }
        return option;
    }

    public static int showYesNoCancelDialog(Window parent, String message, String title, String yesAction, String noAction, int defaultOption) {
        if (Platform.isMacOsX() || Platform.isUnixLikePlatform()) {
            JButton noOption = new JButton(noAction);
            JPanel gap = new JPanel();
            gap.setPreferredSize(new Dimension(24, 8));
            JPanel gap2 = new JPanel();
            gap2.setPreferredSize(new Dimension(24, 8));
            JButton yesOption = new JButton(yesAction);
            JButton cancelOption = new JButton("Cancel");
            Object[] options = Platform.isMacOsX() ? new Object[]{yesOption, cancelOption, gap, noOption, gap2} : new Object[]{yesOption, cancelOption, gap, noOption};
            JButton defaultOpt = defaultOption == 1 ? noOption : (defaultOption == 2 ? cancelOption : yesOption);
            JOptionPane pane = new JOptionPane(message, 2, 1, null, options, defaultOpt);
            pane.setMessage(message);
            final JDialog dialog = pane.createDialog(parent, title);
            final AtomicInteger result = new AtomicInteger(2);
            noOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    result.set(1);
                    dialog.dispose();
                }
            });
            cancelOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    result.set(2);
                    dialog.dispose();
                }
            });
            yesOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    result.set(0);
                    dialog.dispose();
                }
            });
            dialog.setVisible(true);
            return result.get();
        }
        if (defaultOption != 0) {
            JButton noOption = new JButton("No");
            noOption.setMnemonic('n');
            JButton yesOption = new JButton("Yes");
            yesOption.setMnemonic('y');
            JButton cancelOption = new JButton("Cancel");
            cancelOption.setMnemonic('c');
            if (Platform.isWindows()) {
                noOption.setPreferredSize(new Dimension(75, 25));
                yesOption.setPreferredSize(new Dimension(75, 25));
                cancelOption.setPreferredSize(new Dimension(75, 25));
            }
            Object[] options = new Object[]{yesOption, noOption, cancelOption};
            JButton defaultOpt = defaultOption == 1 ? noOption : (defaultOption == 2 ? cancelOption : yesOption);
            JOptionPane pane = new JOptionPane(message, 2, 1, null, options, defaultOpt);
            pane.setMessage(message);
            final JDialog dialog = pane.createDialog(parent, title);
            final AtomicInteger result = new AtomicInteger(2);
            noOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    result.set(1);
                    dialog.dispose();
                }
            });
            cancelOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    result.set(2);
                    dialog.dispose();
                }
            });
            yesOption.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    result.set(0);
                    dialog.dispose();
                }
            });
            dialog.setVisible(true);
            return result.get();
        }
        return JOptionPane.showConfirmDialog(parent, message, title, 1, 2);
    }

    public static boolean isLeftButton(MouseEvent e) {
        int masks = 640;
        return e.getButton() == 1 && (e.getModifiersEx() & masks) == 0;
    }

    public static boolean isRightButton(MouseEvent e) {
        if (e.getButton() == 3) {
            return true;
        }
        return e.getButton() == 1 && (e.getModifiersEx() & 0x80) != 0;
    }

    public static boolean isMiddleButton(MouseEvent e) {
        if (e.getButton() == 2) {
            return true;
        }
        return e.getButton() == 1 && (e.getModifiersEx() & 0x200) != 0;
    }

    public static boolean isShiftClick(int modifiers) {
        return (modifiers & 1) != 0 && (modifiers & 0x18) != 0;
    }

    public static boolean isShift(int modifiers) {
        return (modifiers & 1) != 0;
    }

    public static void makeSpinnerCommitOnEnter(JSpinner spinner, ChangeListener listener) {
        HashSet<AWTKeyStroke> focusKeys = new HashSet<AWTKeyStroke>(spinner.getFocusTraversalKeys(0));
        focusKeys.add(AWTKeyStroke.getAWTKeyStroke(10, 0));
        spinner.setFocusTraversalKeys(0, focusKeys);
        spinner.addChangeListener(listener);
    }

    public static <E extends ILabelDescription> void installModelWithTooltips(JComboBox<E> comboBox, E[] values) {
        comboBox.setModel(new DefaultComboBoxModel<E>(values));
        ListCellRenderer<E> renderer = comboBox.getRenderer();
        if (renderer == null || !renderer.getClass().getName().contains("SynthComboBoxRenderer")) {
            comboBox.setRenderer(new ComboBoxTooltipRenderer((ILabelDescription[])values));
        }
    }

    public static void addPopMenuShortcuts(JComponent parent, Runnable action) {
        AwtTools.addKeyboardShortcut(parent, 1, KeyStroke.getKeyStroke(121, 64), action);
        AwtTools.addKeyboardShortcut(parent, 1, KeyStroke.getKeyStroke(525, 0), action);
    }

    private static Double getScreenScale() {
        String uiScaleStr = System.getProperty("sun.java2d.uiScale");
        Double result = AwtTools.fromString(uiScaleStr);
        if (result != null) {
            return result;
        }
        return null;
    }

    private static Double fromString(String scaleStr) {
        if (StringUtils.isNotBlank(scaleStr)) {
            try {
                return Double.parseDouble(scaleStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    public static double getScaleX() {
        Double result = AwtTools.getScreenScale();
        if (result != null) {
            return result;
        }
        try {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform().getScaleX();
        }
        catch (HeadlessException ex) {
            return 1.0;
        }
    }

    public static double getScaleY() {
        Double result = AwtTools.getScreenScale();
        if (result != null) {
            return result;
        }
        try {
            return GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform().getScaleY();
        }
        catch (HeadlessException ex) {
            return 1.0;
        }
    }

    public static double getScaleX(JComponent cmp) {
        Double result = AwtTools.getScreenScale();
        if (result != null) {
            return result;
        }
        return cmp.getGraphicsConfiguration().getDefaultTransform().getScaleX();
    }

    public static double getScaleY(JComponent cmp) {
        Double result = AwtTools.getScreenScale();
        if (result != null) {
            return result;
        }
        return cmp.getGraphicsConfiguration().getDefaultTransform().getScaleY();
    }

    public static double getScaleX(Window window) {
        Double result = AwtTools.getScreenScale();
        if (result != null) {
            return result;
        }
        return window.getGraphicsConfiguration().getDefaultTransform().getScaleX();
    }

    public static double getScaleY(Window window) {
        Double result = AwtTools.getScreenScale();
        if (result != null) {
            return result;
        }
        return window.getGraphicsConfiguration().getDefaultTransform().getScaleY();
    }

    public static void setMinimumSize(final Window window, final Dimension minimumSize) {
        if (AwtTools.getScaleX(window) == 1.0 && AwtTools.getScaleY(window) == 1.0) {
            window.setMinimumSize(minimumSize);
            return;
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            private void process(MouseEvent e) {
                boolean down;
                boolean bl = down = (e.getModifiersEx() & 0x400) != 0;
                if (!down) {
                    Dimension curSize = window.getSize();
                    if (curSize.width < minimumSize.width || curSize.height < minimumSize.height) {
                        SwingUtilities.invokeLater(() -> window.setSize(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height)));
                    }
                }
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.process(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                this.process(e);
            }
        };
        window.addMouseListener(mouseAdapter);
        window.addMouseMotionListener(mouseAdapter);
    }
}

