/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Painter;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.corebounce.common.gui.AwtTools;
import org.corebounce.common.gui.scaling.JXFrame;
import org.corebounce.common.gui.scaling.Scaler;

public class UIManagerDefaults
implements ActionListener,
ItemListener {
    private static final String[] COLUMN_NAMES = new String[]{"Key", "Value", "Sample"};
    private static String selectedItem;
    private JComponent contentPane;
    private JMenuBar menuBar;
    private JComboBox comboBox;
    private JRadioButton byComponent;
    private JTable table;
    private TreeMap<String, TreeMap<String, Object>> items = new TreeMap();
    private HashMap<String, DefaultTableModel> models = new HashMap();

    public UIManagerDefaults() {
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.add((Component)this.buildNorthComponent(), "North");
        this.contentPane.add((Component)this.buildCenterComponent(), "Center");
        this.resetComponents();
    }

    public JComponent getContentPane() {
        return this.contentPane;
    }

    public JMenuBar getMenuBar() {
        if (this.menuBar == null) {
            this.menuBar = this.createMenuBar();
        }
        return this.menuBar;
    }

    private JComponent buildNorthComponent() {
        this.comboBox = new JComboBox();
        JLabel label = new JLabel("Select Item:");
        label.setDisplayedMnemonic('S');
        label.setLabelFor(this.comboBox);
        this.byComponent = new JRadioButton("By Component", true);
        this.byComponent.setMnemonic('C');
        this.byComponent.addActionListener(this);
        JRadioButton byValueType = new JRadioButton("By Value Type");
        byValueType.setMnemonic('V');
        byValueType.addActionListener(this);
        ButtonGroup group = new ButtonGroup();
        group.add(this.byComponent);
        group.add(byValueType);
        JPanel panel = new JPanel();
        panel.setBorder(new EmptyBorder(15, 0, 15, 0));
        panel.add(label);
        panel.add(this.comboBox);
        panel.add(this.byComponent);
        panel.add(byValueType);
        return panel;
    }

    private JComponent buildCenterComponent() {
        DefaultTableModel model = new DefaultTableModel(COLUMN_NAMES, 0);
        this.table = new JTable(model);
        this.table.setAutoCreateColumnsFromModel(false);
        this.table.getColumnModel().getColumn(0).setPreferredWidth(250);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(500);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(100);
        this.table.getColumnModel().getColumn(2).setCellRenderer(new SampleRenderer());
        Dimension d = this.table.getPreferredSize();
        d.height = 350;
        this.table.setPreferredScrollableViewportSize(d);
        return new JScrollPane(this.table);
    }

    public void resetComponents() {
        this.items.clear();
        this.models.clear();
        ((DefaultTableModel)this.table.getModel()).setRowCount(0);
        this.buildItemsMap();
        Vector<String> comboBoxItems = new Vector<String>(50);
        for (String key : this.items.keySet()) {
            comboBoxItems.add(key);
        }
        this.comboBox.removeItemListener(this);
        this.comboBox.setModel(new DefaultComboBoxModel(comboBoxItems));
        this.comboBox.setSelectedIndex(-1);
        this.comboBox.addItemListener(this);
        this.comboBox.requestFocusInWindow();
        if (selectedItem != null) {
            this.comboBox.setSelectedItem(selectedItem);
        }
    }

    private TreeMap buildItemsMap() {
        UIDefaults defaults = UIManager.getLookAndFeelDefaults();
        Enumeration enumm = defaults.keys();
        while (enumm.hasMoreElements()) {
            Object key = enumm.nextElement();
            Object value = defaults.get(key);
            String itemName = this.getItemName(key.toString(), value);
            if (itemName == null) continue;
            TreeMap<String, Object> attributeMap = this.items.get(itemName);
            if (attributeMap == null) {
                attributeMap = new TreeMap();
                this.items.put(itemName, attributeMap);
            }
            attributeMap.put(key.toString(), value);
        }
        return this.items;
    }

    private String getItemName(String key, Object value) {
        if (key.startsWith("class") || key.startsWith("javax")) {
            return null;
        }
        if (this.byComponent.isSelected()) {
            return this.getComponentName(key, value);
        }
        return this.getValueName(key, value);
    }

    private String getComponentName(String key, Object value) {
        int pos = this.componentNameEndOffset(key);
        String componentName = pos != -1 ? key.substring(0, pos) : (key.endsWith("UI") ? key.substring(0, key.length() - 2) : (value instanceof ColorUIResource ? "System Colors" : "Miscellaneous"));
        if (componentName.equals("Checkbox")) {
            componentName = "CheckBox";
        }
        return componentName;
    }

    private int componentNameEndOffset(String key) {
        if (key.startsWith("\"")) {
            return key.indexOf("\"", 1) + 1;
        }
        int pos = key.indexOf(":");
        if (pos != -1) {
            return pos;
        }
        pos = key.indexOf("[");
        if (pos != -1) {
            return pos;
        }
        return key.indexOf(".");
    }

    private String getValueName(String key, Object value) {
        if (value instanceof Icon) {
            return "Icon";
        }
        if (value instanceof Font) {
            return "Font";
        }
        if (value instanceof Border) {
            return "Border";
        }
        if (value instanceof Color) {
            return "Color";
        }
        if (value instanceof Insets) {
            return "Insets";
        }
        if (value instanceof Boolean) {
            return "Boolean";
        }
        if (value instanceof Dimension) {
            return "Dimension";
        }
        if (value instanceof Number) {
            return "Number";
        }
        if (value instanceof Painter) {
            return "Painter";
        }
        if (key.endsWith("UI")) {
            return "UI";
        }
        if (key.endsWith("InputMap")) {
            return "InputMap";
        }
        if (key.endsWith("RightToLeft")) {
            return "InputMap";
        }
        if (key.endsWith("radient")) {
            return "Gradient";
        }
        return "The Rest";
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        menuBar.add(this.createFileMenu());
        menuBar.add(this.createLAFMenu());
        return menuBar;
    }

    private JMenu createFileMenu() {
        JMenu menu = new JMenu("Application");
        menu.setMnemonic('A');
        menu.addSeparator();
        menu.add(new ExitAction());
        return menu;
    }

    private JMenu createLAFMenu() {
        ButtonGroup bg = new ButtonGroup();
        JMenu menu = new JMenu("Look & Feel");
        menu.setMnemonic('L');
        String lafId = UIManager.getLookAndFeel().getID();
        UIManager.LookAndFeelInfo[] lafInfo = UIManager.getInstalledLookAndFeels();
        int i = 0;
        while (i < lafInfo.length) {
            String laf = lafInfo[i].getClassName();
            String name = lafInfo[i].getName();
            ChangeLookAndFeelAction action = new ChangeLookAndFeelAction(this, laf, name);
            JRadioButtonMenuItem mi = new JRadioButtonMenuItem(action);
            menu.add(mi);
            bg.add(mi);
            if (name.equals(lafId)) {
                mi.setSelected(true);
            }
            ++i;
        }
        return menu;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        selectedItem = null;
        this.resetComponents();
        this.comboBox.requestFocusInWindow();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        String itemName = (String)e.getItem();
        this.changeTableModel(itemName);
        this.updateRowHeights();
        selectedItem = itemName;
    }

    private void changeTableModel(String itemName) {
        DefaultTableModel model = this.models.get(itemName);
        if (model != null) {
            this.table.setModel(model);
            return;
        }
        model = new DefaultTableModel(COLUMN_NAMES, 0);
        Map attributes = this.items.get(itemName);
        for (String attribute : attributes.keySet()) {
            Object value = attributes.get(attribute);
            Vector<String> row = new Vector<String>(3);
            row.add(attribute);
            if (value != null) {
                row.add(value.toString());
                if (value instanceof Icon) {
                    value = new SafeIcon((Icon)value);
                }
                row.add((String)value);
            } else {
                row.add("null");
                row.add("");
            }
            model.addRow(row);
        }
        this.table.setModel(model);
        this.models.put(itemName, model);
    }

    private void updateRowHeights() {
        try {
            int row = 0;
            while (row < this.table.getRowCount()) {
                int rowHeight = this.table.getRowHeight();
                int column = 0;
                while (column < this.table.getColumnCount()) {
                    Component comp = this.table.prepareRenderer(this.table.getCellRenderer(row, column), row, column);
                    rowHeight = Math.max(rowHeight, comp.getPreferredSize().height);
                    ++column;
                }
                this.table.setRowHeight(row, rowHeight);
                ++row;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private static void createAndShowGUI() {
        UIManagerDefaults application = new UIManagerDefaults();
        JFrame.setDefaultLookAndFeelDecorated(true);
        JXFrame frame = new JXFrame("UIManager Defaults");
        frame.setDefaultCloseOperation(3);
        frame.setJMenuBar(application.getMenuBar());
        frame.getContentPane().add(application.getContentPane());
        ((Window)frame).pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }

    public static void main(String[] args) throws Exception {
        AwtTools.switchToNativeLookAndFeel();
        Scaler.init();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UIManagerDefaults.createAndShowGUI();
            }
        });
    }

    class ChangeLookAndFeelAction
    extends AbstractAction {
        private UIManagerDefaults defaults;
        private String laf;

        protected ChangeLookAndFeelAction(UIManagerDefaults defaults, String laf, String name) {
            this.defaults = defaults;
            this.laf = laf;
            this.putValue("Name", name);
            this.putValue("ShortDescription", this.getValue("Name"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                UIManager.setLookAndFeel(this.laf);
                this.defaults.resetComponents();
                JMenuItem mi = (JMenuItem)e.getSource();
                JPopupMenu popup = (JPopupMenu)mi.getParent();
                JRootPane rootPane = SwingUtilities.getRootPane(popup.getInvoker());
                SwingUtilities.updateComponentTreeUI(rootPane);
                JFrame frame = (JFrame)SwingUtilities.windowForComponent(rootPane);
                frame.dispose();
                if (UIManager.getLookAndFeel().getSupportsWindowDecorations()) {
                    frame.setUndecorated(true);
                    frame.getRootPane().setWindowDecorationStyle(1);
                } else {
                    frame.setUndecorated(false);
                }
                frame.setVisible(true);
            }
            catch (Exception ex) {
                System.out.println("Failed loading L&F: " + this.laf);
                System.out.println(ex);
            }
        }
    }

    class ExitAction
    extends AbstractAction {
        public ExitAction() {
            this.putValue("Name", "Exit");
            this.putValue("ShortDescription", this.getValue("Name"));
            this.putValue("MnemonicKey", new Integer(88));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            System.exit(0);
        }
    }

    public static class SafeIcon
    implements Icon {
        private Icon wrappee;
        private Icon standIn;

        public SafeIcon(Icon wrappee) {
            this.wrappee = wrappee;
        }

        @Override
        public int getIconHeight() {
            return this.wrappee.getIconHeight();
        }

        @Override
        public int getIconWidth() {
            return this.wrappee.getIconWidth();
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            if (this.standIn == this) {
                this.paintFallback(c, g, x, y);
            } else if (this.standIn != null) {
                this.standIn.paintIcon(c, g, x, y);
            } else {
                try {
                    this.wrappee.paintIcon(c, g, x, y);
                }
                catch (ClassCastException e) {
                    this.createStandIn(e, x, y);
                    this.standIn.paintIcon(c, g, x, y);
                }
            }
        }

        private void createStandIn(ClassCastException e, int x, int y) {
            try {
                Class<?> clazz = this.getClass(e);
                JComponent standInComponent = this.getSubstitute(clazz);
                this.standIn = this.createImageIcon(standInComponent, x, y);
            }
            catch (Exception e1) {
                this.standIn = this;
            }
        }

        private Icon createImageIcon(JComponent standInComponent, int x, int y) {
            BufferedImage image = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
            Graphics2D g = image.createGraphics();
            AwtTools.setupHighQuality(g);
            try {
                this.wrappee.paintIcon(standInComponent, g, 0, 0);
                ImageIcon imageIcon = new ImageIcon(image);
                return imageIcon;
            }
            finally {
                g.dispose();
            }
        }

        private JComponent getSubstitute(Class<?> clazz) throws IllegalAccessException {
            JComponent standInComponent;
            try {
                standInComponent = (JComponent)clazz.newInstance();
            }
            catch (InstantiationException e) {
                standInComponent = new AbstractButton(){};
                ((AbstractButton)standInComponent).setModel(new DefaultButtonModel());
            }
            return standInComponent;
        }

        private Class<?> getClass(ClassCastException e) throws ClassNotFoundException {
            String message;
            Pattern pattern = Pattern.compile("cannot be cast to (?:class )?([\\w\\.]+)");
            Matcher matcher = pattern.matcher(message = e.getMessage());
            if (matcher.find()) {
                String className = matcher.group(1);
                return Class.forName(className);
            }
            throw e;
        }

        private void paintFallback(Component c, Graphics g, int x, int y) {
            g.drawRect(x, y, this.getIconWidth(), this.getIconHeight());
            g.drawLine(x, y, x + this.getIconWidth(), y + this.getIconHeight());
            g.drawLine(x + this.getIconWidth(), y, x, y + this.getIconHeight());
        }
    }

    class SampleRenderer
    extends JLabel
    implements TableCellRenderer {
        public SampleRenderer() {
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object sample, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(null);
            this.setBorder(null);
            this.setIcon(null);
            this.setText("");
            if (sample instanceof Color) {
                this.setBackground((Color)sample);
            } else if (sample instanceof Border) {
                this.setBorder((Border)sample);
            } else if (sample instanceof Font) {
                this.setText("Sample");
                this.setFont((Font)sample);
            } else if (sample instanceof Icon) {
                this.setIcon((Icon)sample);
            }
            return this;
        }

        @Override
        public void paint(Graphics g) {
            try {
                super.paint(g);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

