/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.gui.aa;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import org.corebounce.common.gui.aa.JAToolTip;
import org.corebounce.common.gui.scaling.Scaler;
import org.corebounce.common.utils.Platform;

public class WindowsScalingHacks {
    private static final boolean ENABLED = true;
    private static final boolean enabled;
    private static final boolean scaled;
    private static double scaleX;
    private static double scaleY;

    static {
        scaleX = 1.0;
        scaleY = 1.0;
        boolean result = false;
        boolean isScaled = false;
        if (Platform.isWindows() && !Platform.isBelowJava19()) {
            try {
                AffineTransform at = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getDefaultTransform();
                scaleX = at.getScaleX();
                scaleY = at.getScaleY();
                if ((float)scaleX != (float)Math.round(scaleX) || (float)scaleY != (float)Math.round(scaleY)) {
                    result = true;
                }
                if (Scaler.getScale() != 1.0) {
                    result = true;
                }
                if (scaleX != 1.0 || scaleY != 1.0) {
                    isScaled = true;
                }
            }
            catch (HeadlessException headlessException) {
                // empty catch block
            }
        }
        enabled = result;
        scaled = isScaled;
    }

    public static void paint(Graphics g, JComponent cmp, Consumer<Graphics> superPaint) {
        if (enabled) {
            Graphics2D g2 = (Graphics2D)g;
            g2 = (Graphics2D)g2.create();
            if (cmp.isOpaque()) {
                g2.setColor(cmp.getBackground());
                g2.fillRect(0, 0, cmp.getWidth() + 1, cmp.getHeight() + 1);
            }
            WindowsScalingHacks.setupHighQuality(g2);
            superPaint.accept(g2);
            g2.dispose();
        } else {
            superPaint.accept(g);
        }
    }

    public static JToolTip createTooltip(JComponent forCmp) {
        JAToolTip tip = new JAToolTip();
        tip.setComponent(forCmp);
        return tip;
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean isScaled() {
        return scaled;
    }

    public static void setupHighQuality(Graphics2D g) {
        g.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_ENABLE);
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    public static double getScaleX() {
        return scaleX;
    }

    public static double getScaleY() {
        return scaleY;
    }
}

