/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.gui.image;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.corebounce.common.gui.image.SketchifiedImage;
import org.corebounce.common.struct.CacheMap;
import org.corebounce.common.utils.MultiKey;

public class IconLoader {
    private static Map<MultiKey, ImageIcon> iconCache = new CacheMap<MultiKey, ImageIcon>();
    private static boolean napkin = IconLoader.isNapkin();

    public static synchronized ImageIcon getImageIcon(Class<?> forClass, String path, int width, int height) {
        MultiKey key;
        ImageIcon icon;
        if (napkin != IconLoader.isNapkin()) {
            napkin = IconLoader.isNapkin();
            iconCache.clear();
        }
        if ((icon = iconCache.get(key = new MultiKey(forClass, path, width, height))) == null) {
            URL imgURL = forClass.getResource(path);
            if (imgURL == null) {
                return null;
            }
            icon = new ImageIcon(imgURL);
            if (width > 0 && icon.getIconWidth() != width || height > 0 && icon.getIconHeight() != height) {
                if (width <= 0) {
                    width = icon.getIconWidth();
                }
                if (height <= 0) {
                    height = icon.getIconHeight();
                }
                Image img = icon.getImage().getScaledInstance(width, height, 4);
                icon = new ImageIcon(img);
            }
            if (IconLoader.isNapkin()) {
                Image orig = icon.getImage();
                BufferedImage sketch = SketchifiedImage.sketchify(orig);
                icon = new ImageIcon(sketch);
            }
            iconCache.put(key, icon);
        }
        return icon;
    }

    private static boolean isNapkin() {
        return UIManager.getLookAndFeel().getClass().getName().contains("NapkinLookAndFeel");
    }

    public static ImageIcon getIcon(Class<?> forClass, String path, int size) {
        return IconLoader.getIcon(forClass, path, size, size);
    }

    public static ImageIcon getIcon(Class<?> forClass, String path, int width, int height) {
        return IconLoader.getImageIcon(forClass, path, width, height);
    }

    public static Image getImage(Class<?> forClass, String path, int size) {
        return IconLoader.getImage(forClass, path, size, size);
    }

    public static Image getImage(Class<?> forClass, String path, int width, int height) {
        ImageIcon icon = IconLoader.getIcon(forClass, path, width, height);
        return icon.getImage();
    }
}

