/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.gui.scaling;

import ch.tachyon.tunnel.common.utils.Debug;
import ch.tachyon.tunnel.common.utils.Utils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.MenuElement;
import javax.swing.RootPaneContainer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.plaf.FontUIResource;
import org.corebounce.common.gui.scaling.IPreScaled;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.StringUtils;

public class Scaler {
    private static final boolean ENABLED = false;
    private static double scale = 1.0;
    private static boolean initialized;

    public static void init() {
    }

    public static void roundScale() {
        if (!Platform.isWindows()) {
            return;
        }
        double uiScale = 1.0;
        try {
            uiScale = Scaler.getUiScaleImpl();
        }
        catch (IOException ex) {
            Debug.error(ex);
        }
        if (uiScale == 1.0) {
            return;
        }
        double roundScale = (double)Math.round(uiScale * 2.0 - 0.1) / 2.0;
        if ((float)roundScale != (float)uiScale) {
            scale = uiScale / roundScale;
            Scaler.setUiScale(roundScale);
            Enumeration keys = UIManager.getDefaults().keys();
            while (keys.hasMoreElements()) {
                Object key = keys.nextElement();
                Object value = UIManager.get(key);
                if (!(value instanceof FontUIResource)) continue;
                FontUIResource font = (FontUIResource)value;
                UIManager.put(key, new FontUIResource(font.deriveFont(0, font.getSize2D() * (float)scale)));
            }
        }
    }

    public static void scaleFileChooserFont(Component[] comp) {
        if (!Platform.isWindows()) {
            return;
        }
        if (scale == 1.0) {
            return;
        }
        int x = 0;
        while (x < comp.length) {
            if (comp[x] instanceof Container) {
                Scaler.scaleFileChooserFont(((Container)comp[x]).getComponents());
            }
            try {
                if (comp[x] instanceof JList || comp[x] instanceof JTable) {
                    comp[x].setFont(comp[x].getFont().deriveFont((float)comp[x].getFont().getSize() * (float)scale));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++x;
        }
    }

    public static void initDisabled() {
        initialized = true;
    }

    public static double getScale() {
        return scale;
    }

    private static double getUiScale() throws IOException {
        if (!Platform.isWindows() || Utils.isBelowJava19()) {
            return 1.0;
        }
        if (StringUtils.isNotBlank(System.getProperty("sun.java2d.uiScale"))) {
            return 1.0;
        }
        return Scaler.getUiScaleImpl();
    }

    private static double getUiScaleImpl() throws IOException {
        InputStream input = Scaler.class.getResourceAsStream("GetScreenScaling.ps1");
        Path tempFile = Files.createTempFile("GetScreenScaling", ".ps1", new FileAttribute[0]);
        try {
            Files.copy(input, tempFile, StandardCopyOption.REPLACE_EXISTING);
            ProcessBuilder builder = new ProcessBuilder("powershell", "-executionPolicy", "bypass", "-file", tempFile.toAbsolutePath().toString());
            Process process = builder.start();
            InputStream stdout = process.getInputStream();
            InputStreamReader reader = new InputStreamReader(stdout);
            BufferedReader breader = new BufferedReader(reader);
            String resString = breader.readLine();
            if (resString == null) {
                return 1.0;
            }
            while (breader.read() >= 0) {
            }
            try {
                double d = Double.parseDouble(resString) / 100.0;
                return d;
            }
            catch (NumberFormatException ex) {
                Debug.error(ex);
                Files.deleteIfExists(tempFile);
                return 1.0;
            }
        }
        finally {
            Files.deleteIfExists(tempFile);
        }
    }

    private static void setUiScale(double scale) {
        System.setProperty("sun.java2d.uiScale", String.valueOf(scale));
    }

    static void scale(Component cmp) {
        if (cmp == null || scale == 1.0) {
            return;
        }
        if (cmp instanceof RootPaneContainer) {
            Scaler.scaleWindow((RootPaneContainer)((Object)cmp));
            return;
        }
        Scaler.scale(cmp, scale, Collections.newSetFromMap(new IdentityHashMap()));
    }

    private static void scaleWindow(RootPaneContainer window) {
        Scaler.scale(window.getContentPane());
        Scaler.scale(window.getRootPane().getJMenuBar());
    }

    private static void scale(Component cmp, double factor, Set<Component> processed) {
        int n;
        Font font;
        if (processed.contains(cmp)) {
            return;
        }
        processed.add(cmp);
        if (cmp instanceof JSpinner.DefaultEditor) {
            return;
        }
        if (!(cmp instanceof IPreScaled) && (font = cmp.getFont()) != null) {
            float resize = Math.round((double)font.getSize2D() * factor + 0.3);
            cmp.setFont(font.deriveFont(resize));
        }
        if (cmp instanceof JComponent) {
            TitledBorder tborder;
            Font tfont;
            JComponent jcmp = (JComponent)cmp;
            Border border = jcmp.getBorder();
            if (border instanceof TitledBorder && (tfont = (tborder = (TitledBorder)border).getTitleFont()) != null) {
                float resize = Math.round((double)tfont.getSize2D() * factor + 0.3);
                tborder.setTitleFont(tfont.deriveFont(resize));
            }
            Component[] componentArray = jcmp.getComponents();
            int n2 = componentArray.length;
            n = 0;
            while (n < n2) {
                Component child = componentArray[n];
                Scaler.scale(child, factor, processed);
                ++n;
            }
        }
        if (cmp instanceof MenuElement) {
            MenuElement menu = (MenuElement)((Object)cmp);
            MenuElement[] menuElementArray = menu.getSubElements();
            n = menuElementArray.length;
            int n3 = 0;
            while (n3 < n) {
                MenuElement child = menuElementArray[n3];
                Scaler.scale((JComponent)((Object)child), factor, processed);
                ++n3;
            }
        }
    }
}

