/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.io;

import ch.tachyon.tunnel.common.utils.Debug;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Properties;
import org.corebounce.common.io.CodecInputStream;

public class IOUtils {
    public static void close(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (IOException ex) {
            Debug.error(ex);
        }
    }

    public static void loadUtf8Properties(InputStream input, Properties properties) throws IOException {
        CodecInputStream codec = new CodecInputStream(input, Charset.forName("UTF-8"), Charset.forName("ISO-8859-1"));
        properties.load(codec);
    }

    public static byte[] readAll(InputStream input) throws IOException {
        ByteArrayOutputStream target = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int read = input.read(buffer);
        while (read > 0) {
            target.write(buffer, 0, read);
            read = input.read(buffer);
        }
        target.close();
        return target.toByteArray();
    }
}

