/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.io;

import ch.tachyon.tunnel.common.utils.Debug;
import ch.tachyon.tunnel.common.utils.Utils;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.corebounce.common.io.Base64;
import org.corebounce.common.utils.Platform;

public class Prefs {
    private static Package curPackage = null;
    private static Preferences curPrefs = null;
    private static Boolean systemPrefsReadAccess;
    private static Boolean systemPrefsWriteAccess;

    private Prefs() {
    }

    private static Preferences prefs(Class<?> clazz) {
        Package pack = clazz.getPackage();
        if (!pack.equals(curPackage)) {
            curPackage = pack;
            curPrefs = Preferences.userNodeForPackage(clazz);
        }
        return curPrefs;
    }

    private static Preferences systemPrefs(Class<?> clazz) {
        return Preferences.systemNodeForPackage(clazz);
    }

    public static String getString(Class<?> clazz, String key, String def) {
        String part;
        String result = Prefs.prefs(clazz).get(key, null);
        if (result != null) {
            return result;
        }
        StringBuilder builder = new StringBuilder();
        int index = 0;
        while ((part = Prefs.prefs(clazz).get(String.valueOf(key) + "." + index, null)) != null) {
            builder.append(part);
            ++index;
        }
        if (index == 0) {
            return def;
        }
        return builder.toString();
    }

    public static void putString(Class<?> clazz, String key, String value) {
        int index = 0;
        if (value.length() <= 8192) {
            Prefs.prefs(clazz).put(key, value);
        } else {
            Prefs.prefs(clazz).remove(key);
            int offset = 0;
            while (offset < value.length()) {
                int amount = Math.min(value.length() - offset, 8192);
                Prefs.prefs(clazz).put(String.valueOf(key) + "." + index, value.substring(offset, offset + amount));
                offset += amount;
                ++index;
            }
            if (index > 10) {
                Debug.warn("Class {0} has put a long preference value for key {1}, length: {2}", clazz.getSimpleName(), key, value.length());
            }
        }
        while (Prefs.prefs(clazz).get(String.valueOf(key) + "." + index, null) != null) {
            Prefs.prefs(clazz).remove(String.valueOf(key) + "." + index);
            ++index;
        }
    }

    public static long getLong(Class<?> clazz, String key, long def) {
        return Prefs.prefs(clazz).getLong(key, def);
    }

    public static void putLong(Class<?> clazz, String key, long value) {
        Prefs.prefs(clazz).putLong(key, value);
    }

    public static int getInt(Class<?> clazz, String key, int def) {
        return Prefs.prefs(clazz).getInt(key, def);
    }

    public static void putInt(Class<?> clazz, String key, int value) {
        Prefs.prefs(clazz).putInt(key, value);
    }

    public static float getFloat(Class<?> clazz, String key, float def) {
        return Prefs.prefs(clazz).getFloat(key, def);
    }

    public static void putFloat(Class<?> clazz, String key, float value) {
        Prefs.prefs(clazz).putFloat(key, value);
    }

    public static double getDouble(Class<?> clazz, String key, double def) {
        return Prefs.prefs(clazz).getDouble(key, def);
    }

    public static void putDouble(Class<?> clazz, String key, double value) {
        Prefs.prefs(clazz).putDouble(key, value);
    }

    public static boolean getBoolean(Class<?> clazz, String key, boolean def) {
        return Prefs.prefs(clazz).getBoolean(key, def);
    }

    public static void putBoolean(Class<?> clazz, String key, boolean value) {
        Prefs.prefs(clazz).putBoolean(key, value);
    }

    public static void remove(Class<?> clazz, String key) {
        Prefs.prefs(clazz).remove(key);
    }

    public static void removeAll(Class<?> clazz, int parentLevels) {
        Prefs.removeAll(clazz, parentLevels, false);
    }

    public static void removeAll(Class<?> clazz, int parentLevels, boolean system) {
        Preferences prefs = system ? Prefs.systemPrefs(clazz) : Prefs.prefs(clazz);
        int k = 0;
        while (k < parentLevels) {
            prefs = prefs.parent();
            ++k;
        }
        try {
            Prefs.removeAll(prefs);
            prefs.flush();
        }
        catch (BackingStoreException ex) {
            Debug.error(ex);
        }
    }

    private static void removeAll(Preferences prefs) throws BackingStoreException {
        if (!prefs.nodeExists("")) {
            return;
        }
        String[] stringArray = prefs.childrenNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            Prefs.removeAll(prefs.node(child));
            ++n2;
        }
        prefs.removeNode();
    }

    public static void migrate(String oldLocation, String newLocation) throws BackingStoreException, IOException {
        String oldPath = "/" + oldLocation.replace('.', '/');
        if (!Preferences.userRoot().nodeExists(oldPath)) {
            return;
        }
        Preferences oldPrefs = Preferences.userRoot().node(oldPath);
        try {
            String[] keys = Prefs.\u00a3(oldPrefs.keys());
            String[] children = Prefs.\u00a3(oldPrefs.childrenNames());
            if (keys.length == 0 && children.length == 0) {
                return;
            }
            String newPath = "/" + newLocation.replace('.', '/');
            Preferences newPrefs = Preferences.userRoot().node(newPath);
            Prefs.migrate(oldPrefs, newPrefs);
        }
        finally {
            Prefs.removeAll(oldPrefs);
        }
    }

    private static void migrate(Preferences oldPrefs, Preferences newPrefs) throws BackingStoreException {
        String[] stringArray = Prefs.\u00a3(oldPrefs.keys());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String oldValue;
            String newValue;
            String key = stringArray[n2];
            if (!key.endsWith(".test") && (newValue = newPrefs.get(key, null)) == null && (oldValue = oldPrefs.get(key, null)) != null) {
                newPrefs.put(key, oldValue);
            }
            ++n2;
        }
        stringArray = Prefs.\u00a3(oldPrefs.childrenNames());
        n = stringArray.length;
        n2 = 0;
        while (n2 < n) {
            String child = stringArray[n2];
            Preferences oldChild = oldPrefs.node(child);
            Preferences newChild = newPrefs.node(child);
            Prefs.migrate(oldChild, newChild);
            ++n2;
        }
    }

    public static void migrateItem(String oldPackage, String oldKey, Class<?> classNewPackage, String newKey) throws BackingStoreException {
        String oldValue;
        String oldPath = "/" + oldPackage.replace('.', '/');
        if (!Preferences.userRoot().nodeExists(oldPath)) {
            return;
        }
        Preferences oldPrefs = Preferences.userRoot().node(oldPath);
        Preferences newPrefs = Preferences.userNodeForPackage(classNewPackage);
        String newValue = newPrefs.get(newKey, null);
        if (newValue == null && (oldValue = oldPrefs.get(oldKey, null)) != null) {
            newPrefs.put(newKey, oldValue);
        }
        oldPrefs.remove(oldKey);
    }

    private static String[] \u00a3(String[] arr) {
        if (arr == null) {
            return new String[0];
        }
        return arr;
    }

    public static <E> E getObject(Class<?> clazz, String key, E def, Class<E> type) {
        String data = Prefs.prefs(clazz).get(key, null);
        if (data != null) {
            byte[] byteArr = Base64.decode(data);
            try {
                return Utils.fromByteArray(byteArr, type);
            }
            catch (Exception ex) {
                return def;
            }
        }
        ArrayList<String> parts = new ArrayList<String>();
        int index = 0;
        String part = null;
        while ((part = Prefs.prefs(clazz).get(String.valueOf(key) + "." + index, null)) != null) {
            parts.add(part);
            ++index;
        }
        if (parts.isEmpty()) {
            return def;
        }
        StringBuilder result = new StringBuilder();
        for (String item : parts) {
            result.append(item);
        }
        try {
            return Utils.fromByteArray(Base64.decode(result.toString()), type);
        }
        catch (Exception ex) {
            return def;
        }
    }

    public static <E> void putObject(Class<?> clazz, String key, E value) {
        int index = 0;
        byte[] byteArr = Utils.toByteArray(value);
        String data = Base64.encode(byteArr);
        if (data.length() <= 8192) {
            Prefs.prefs(clazz).put(key, data);
        } else {
            Prefs.remove(clazz, key);
            int offset = 0;
            while (offset < data.length()) {
                int amount = Math.min(data.length() - offset, 8192);
                String block = data.substring(offset, offset + amount);
                Prefs.prefs(clazz).put(String.valueOf(key) + "." + index, block);
                offset += amount;
                ++index;
            }
            if (index > 10) {
                Debug.warn("Class {0} has put a long preference value for key {1}, length: {2}", clazz.getSimpleName(), key, data.length());
            }
        }
        while (Prefs.prefs(clazz).get(String.valueOf(key) + "." + index, null) != null) {
            Prefs.prefs(clazz).remove(String.valueOf(key) + "." + index);
            ++index;
        }
    }

    public static synchronized boolean hasSystemPrefsReadAccess() {
        String systemPrefsDirName;
        File systemRootDir;
        if (systemPrefsReadAccess != null) {
            return systemPrefsReadAccess;
        }
        if (!(!Platform.isUnixLikePlatform() || (systemRootDir = new File(systemPrefsDirName = System.getProperty("java.util.prefs.systemRoot", "/etc/.java"), ".systemPrefs")).isDirectory() && Files.isWritable(systemRootDir.toPath()))) {
            systemPrefsReadAccess = false;
            return false;
        }
        systemPrefsReadAccess = true;
        return true;
    }

    public static synchronized boolean hasSystemPrefsWriteAccess() {
        if (systemPrefsWriteAccess != null) {
            return systemPrefsWriteAccess;
        }
        if (!Prefs.hasSystemPrefsReadAccess()) {
            systemPrefsWriteAccess = false;
            return false;
        }
        systemPrefsWriteAccess = Prefs.runSuppressPrefsLogs(() -> {
            try {
                Preferences preferences = Preferences.systemRoot();
                preferences.put("foo", "bar");
                preferences.remove("foo");
                preferences.flush();
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        });
        return systemPrefsWriteAccess;
    }

    public static synchronized <R> R runSuppressPrefsLogs(Supplier<R> action) {
        Logger prefsLogger = Logger.getLogger("java.util.prefs");
        Level prevLevel = null;
        if (prefsLogger != null) {
            prevLevel = prefsLogger.getLevel();
            prefsLogger.setLevel(Level.SEVERE);
        }
        PrintStream prevErr = System.err;
        System.setErr(new PrintStream(new OutputStream(){

            @Override
            public void write(int b) {
            }
        }));
        try {
            R r = action.get();
            return r;
        }
        finally {
            System.setErr(prevErr);
            if (prefsLogger != null && prevLevel != null) {
                prefsLogger.setLevel(prevLevel);
            }
        }
    }
}

