/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomFileInputStream
extends InputStream {
    private final RandomAccessFile raFile;
    private long markPos = -1L;

    public RandomFileInputStream(File file) throws IOException {
        this.raFile = new RandomAccessFile(file, "r");
    }

    @Override
    public int read() throws IOException {
        return this.raFile.read();
    }

    @Override
    public int available() throws IOException {
        return (int)(this.raFile.length() - this.raFile.getFilePointer());
    }

    @Override
    public void close() throws IOException {
        this.raFile.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.markPos = this.raFile.getFilePointer();
        }
        catch (IOException ex) {
            this.markPos = -2L;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raFile.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.raFile.read(b);
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markPos == -2L) {
            throw new IOException("mark() failed to get file pointer");
        }
        if (this.markPos == -1L) {
            throw new IOException("No mark()");
        }
        this.raFile.seek(this.markPos);
    }

    @Override
    public long skip(long n) throws IOException {
        return this.raFile.skipBytes((int)n);
    }
}

