/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.log;

import ch.tachyon.tunnel.common.utils.Debug;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.corebounce.common.log.LogEntry;

public class EventTrace {
    private static final int MAX_LOG_LINES = 1000;
    private static final List<LogEntry> logEntries = new LinkedList<LogEntry>();
    private static final List<LogEntry> exceptionEntries = new LinkedList<LogEntry>();

    public static synchronized void addLogEntry(LogEntry logEntry) {
        logEntries.add(logEntry);
        while (logEntries.size() > 1000) {
            logEntries.remove(0);
        }
    }

    public static synchronized void addExceptionEntry(LogEntry logEntry) {
        exceptionEntries.add(logEntry);
        while (exceptionEntries.size() > 1000) {
            exceptionEntries.remove(0);
        }
    }

    public static synchronized List<LogEntry> getLogEntries() {
        return new ArrayList<LogEntry>(logEntries);
    }

    public static synchronized List<LogEntry> getExceptionEntries() {
        return new ArrayList<LogEntry>(exceptionEntries);
    }

    public static synchronized String getLog(boolean includeFileNames, Map<String, String> replacements) {
        StringBuilder result = new StringBuilder();
        for (LogEntry entry : logEntries) {
            result.append(String.valueOf(entry.toString()) + "\n");
        }
        return EventTrace.process(result.toString(), includeFileNames, replacements);
    }

    public static synchronized String getExceptions(boolean includeFileNames, Map<String, String> replacements) {
        StringBuilder result = new StringBuilder();
        for (LogEntry entry : exceptionEntries) {
            result.append(String.valueOf(entry.toString()) + "\n");
        }
        return EventTrace.process(result.toString(), includeFileNames, replacements);
    }

    private static String process(String text, boolean includeFileNames, Map<String, String> replacements) {
        if (includeFileNames) {
            return text.replaceAll("\u00ab(.*?)\u00bb", "$1");
        }
        for (Map.Entry<String, String> entry : replacements.entrySet()) {
            String fileName = entry.getKey();
            if (!text.contains(fileName)) continue;
            String hash = entry.getValue();
            text = text.replace(fileName, hash);
        }
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            Pattern pattern = Pattern.compile("\u00ab(.*?)\u00bb");
            StringBuffer result = new StringBuffer();
            Matcher m = pattern.matcher(text);
            while (m.find()) {
                String fileName = m.group(1);
                byte[] hash = digest.digest(fileName.getBytes(StandardCharsets.UTF_8));
                String replacement = "\u00ab" + Base64.getEncoder().encodeToString(hash) + "\u00bb";
                m.appendReplacement(result, replacement);
                replacements.put(fileName, replacement);
            }
            m.appendTail(result);
            return result.toString();
        }
        catch (NoSuchAlgorithmException ex) {
            Debug.error(ex);
            return text;
        }
    }

    public static synchronized void clear() {
        logEntries.clear();
        exceptionEntries.clear();
    }
}

