/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.log;

import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.corebounce.common.log.EventTrace;
import org.corebounce.common.log.LogEntry;

public class EventTraceHandler
extends Handler {
    @Override
    public void publish(LogRecord record) {
        String formattedMessage = this.getFormatter().formatMessage(record);
        LogEntry entry = new LogEntry(record.getMillis(), record.getLevel(), record.getSourceClassName(), record.getSourceMethodName(), formattedMessage);
        if (record.getThrown() == null) {
            EventTrace.addLogEntry(entry);
        } else {
            EventTrace.addExceptionEntry(entry);
            EventTrace.addLogEntry(entry.shortened());
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws SecurityException {
    }
}

