/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.log;

import java.io.Serializable;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.logging.Level;

public class LogEntry
implements Serializable {
    private static final int MAX_MESSAGE_LENGTH = 400;
    private long time;
    private Level level;
    private String className;
    private String methodName;
    private String message;

    public LogEntry(long time, Level level, String className, String methodName, String message) {
        String[] lines = message.split("\r?\n");
        StringBuilder msg = new StringBuilder();
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.length() > 400) {
                line = String.valueOf(line.substring(0, 200)) + "\u2026" + line.substring(line.length() - 200);
            }
            if (msg.length() > 0) {
                msg.append("\n");
            }
            msg.append(line);
            ++n2;
        }
        this.time = time;
        this.level = level;
        this.className = className;
        this.methodName = methodName;
        this.message = msg.toString();
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        this.level = level;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getShortClassName() {
        if (this.className == null) {
            return null;
        }
        int lastDotPos = this.className.lastIndexOf(46);
        return this.className.substring(lastDotPos + 1);
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public LogEntry shortened() {
        if (this.message == null) {
            return this;
        }
        String[] messageLines = this.message.split("\\r?\\n");
        if (messageLines.length <= 1) {
            return this;
        }
        String newMessage = messageLines[0];
        return new LogEntry(this.time, this.level, this.className, this.methodName, newMessage);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        LocalDateTime when = Instant.ofEpochMilli(this.time).atZone(ZoneId.systemDefault()).toLocalDateTime();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
        result.append(formatter.format(when));
        result.append(' ');
        result.append(this.level);
        result.append(' ');
        result.append(this.getShortClassName());
        result.append(' ');
        result.append(this.methodName);
        result.append(": ");
        result.append(this.message);
        return result.toString();
    }
}

