/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.log;

import ch.tachyon.tunnel.common.utils.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.corebounce.common.log.EventTraceHandler;
import org.corebounce.common.log.LogEntry;

public class LogFormatter
extends Formatter {
    private static volatile Level logLevel = Level.WARNING;
    private static volatile Level eventTraceLevel = Level.INFO;

    @Override
    public String format(LogRecord record) {
        String formattedMessage = this.formatMessage(record);
        LogEntry entry = new LogEntry(record.getMillis(), record.getLevel(), record.getSourceClassName(), record.getSourceMethodName(), formattedMessage.toString());
        return String.valueOf(entry.toString()) + Utils.NEW_LINE;
    }

    @Override
    public synchronized String formatMessage(LogRecord record) {
        StringBuilder formattedMessage = new StringBuilder();
        String message = record.getMessage();
        if (message == null) {
            message = "";
        }
        message = message.replace('\n', ' ');
        if (record.getParameters() != null && record.getParameters().length > 0) {
            formattedMessage.append(MessageFormat.format(message, record.getParameters()));
        } else {
            formattedMessage.append(message);
        }
        Throwable ex = record.getThrown();
        if (ex != null) {
            formattedMessage.append("\n");
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            formattedMessage.append(writer.getBuffer());
        }
        return formattedMessage.toString();
    }

    public static void setup() {
        LogFormatter.setup(Level.WARNING, Level.INFO);
    }

    public static void setup(Level logLevel, Level eventTraceLevel) {
        LogFormatter.logLevel = logLevel;
        LogFormatter.eventTraceLevel = eventTraceLevel;
        Logger logger = Logger.getLogger("");
        Handler toRemove = null;
        LogFormatter formatter = new LogFormatter();
        Handler[] handlerArray = logger.getHandlers();
        int n = handlerArray.length;
        int n2 = 0;
        while (n2 < n) {
            Handler handler = handlerArray[n2];
            if (handler instanceof EventTraceHandler) {
                toRemove = handler;
            } else {
                handler.setFormatter(formatter);
                handler.setLevel(logLevel);
            }
            ++n2;
        }
        if (toRemove != null) {
            logger.removeHandler(toRemove);
        }
        EventTraceHandler etHandler = new EventTraceHandler();
        etHandler.setFormatter(formatter);
        etHandler.setLevel(eventTraceLevel);
        logger.addHandler(etHandler);
        logger.setLevel(LogFormatter.min(logLevel, eventTraceLevel));
    }

    public static void setupAfterSwingStart() {
        Logger.getLogger("").setLevel(LogFormatter.min(logLevel, eventTraceLevel));
    }

    private static Level min(Level l1, Level l2) {
        if (l1.intValue() < l2.intValue()) {
            return l1;
        }
        return l2;
    }
}

