/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.math;

public class FastMath {
    private static final double B = 1.2732395447351628;
    private static final double C = -0.4052847345693511;
    private static final double P = 0.218;
    private static final double hPI = 1.5707963267948966;
    private static final double PI2 = Math.PI * 2;
    private static final double sPI = 4.71238898038469;
    private static final double sq2p1 = 2.414213562373095;
    private static final double sq2m1 = 0.41421356237309503;
    private static final double p4 = 16.15364129822302;
    private static final double p3 = 268.42548195503974;
    private static final double p2 = 1153.029351540485;
    private static final double p1 = 1780.406316433197;
    private static final double p0 = 896.7859740366387;
    private static final double q4 = 58.95697050844462;
    private static final double q3 = 536.2653740312153;
    private static final double q2 = 1666.7838148816338;
    private static final double q1 = 2079.33497444541;
    private static final double q0 = 896.7859740366387;
    private static final double PIO2 = 1.5707963267948966;

    public static double wrap(double angle) {
        if ((angle %= Math.PI * 2) > Math.PI) {
            angle -= Math.PI * 2;
        } else if (angle < -Math.PI) {
            angle += Math.PI * 2;
        }
        assert (angle >= -Math.PI && angle <= Math.PI);
        return angle;
    }

    public static double fastSin(double theta) {
        return FastMath.fastSin0(FastMath.wrap(theta));
    }

    public static double fastCos(double theta) {
        return FastMath.fastSin0(FastMath.wrap(theta + 1.5707963267948966));
    }

    public static double fastSin0(double theta) {
        double y = 1.2732395447351628 * theta + -0.4052847345693511 * theta * Math.abs(theta);
        y = 0.218 * (y * Math.abs(y) - y) + y;
        return y;
    }

    public static double fastCos0(double theta) {
        theta = theta > 1.5707963267948966 ? (theta -= 4.71238898038469) : (theta += 1.5707963267948966);
        return FastMath.fastSin0(theta);
    }

    private static double mxatan(double arg) {
        double argsq = arg * arg;
        double value = (((16.15364129822302 * argsq + 268.42548195503974) * argsq + 1153.029351540485) * argsq + 1780.406316433197) * argsq + 896.7859740366387;
        return (value /= ((((argsq + 58.95697050844462) * argsq + 536.2653740312153) * argsq + 1666.7838148816338) * argsq + 2079.33497444541) * argsq + 896.7859740366387) * arg;
    }

    private static double msatan(double arg) {
        return arg < 0.41421356237309503 ? FastMath.mxatan(arg) : (arg > 2.414213562373095 ? 1.5707963267948966 - FastMath.mxatan(1.0 / arg) : 0.7853981633974483 + FastMath.mxatan((arg - 1.0) / (arg + 1.0)));
    }

    public static double atan(double arg) {
        return arg > 0.0 ? FastMath.msatan(arg) : -FastMath.msatan(-arg);
    }

    public static double atan2(double arg1, double arg2) {
        if (arg1 + arg2 == arg1) {
            return arg1 >= 0.0 ? 1.5707963267948966 : -1.5707963267948966;
        }
        arg1 = FastMath.atan(arg1 / arg2);
        return arg2 < 0.0 ? (arg1 <= 0.0 ? arg1 + Math.PI : arg1 - Math.PI) : arg1;
    }

    public static double exp(double val) {
        long tmp = (long)(1512775.0 * val + 1.072632447E9);
        return Double.longBitsToDouble(tmp << 32);
    }

    public static double log(double x) {
        return 6.0 * (x - 1.0) / (x + 1.0 + 4.0 * Math.sqrt(x));
    }

    public static double pow(double a, double b) {
        int x = (int)(Double.doubleToLongBits(a) >> 32);
        int y = (int)(b * (double)(x - 1072632447) + 1.072632447E9);
        return Double.longBitsToDouble((long)y << 32);
    }

    public static float floor(float value) {
        assert (value >= 0.0f);
        return (int)value;
    }

    public static double floor(double value) {
        assert (value >= 0.0);
        return (long)value;
    }

    public static double fastSqrt(double a) {
        long x = Double.doubleToLongBits(a) >> 32;
        double y = Double.longBitsToDouble(x + 1072632448L << 31);
        return y;
    }

    public static double sqrt(double a) {
        long x = Double.doubleToLongBits(a) >> 32;
        double y = Double.longBitsToDouble(x + 1072632448L << 31);
        y = (y + a / y) * 0.5;
        return y;
    }

    public static float max(float v1, float v2) {
        return v1 > v2 ? v1 : v2;
    }

    public static float min(float v1, float v2) {
        return v1 > v2 ? v2 : v1;
    }

    public static void main(String[] args) {
        int i = 1;
        while (i < 20) {
            double v1 = i;
            System.out.println(v1 + ": " + FastMath.sqrt(v1) + " / " + Math.sqrt(v1));
            double v2 = 1.0 / (double)i;
            System.out.println(v2 + ": " + FastMath.sqrt(v2) + " / " + Math.sqrt(v2));
            ++i;
        }
    }
}

