/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.power;

import ch.tachyon.tunnel.common.utils.Debug;
import com.sun.jna.platform.mac.CoreFoundation;
import com.sun.jna.ptr.IntByReference;
import org.corebounce.common.power.AppleIOKit;

class ApplePowerManagement {
    private static int sleepPreventionAssertionId = 0;

    ApplePowerManagement() {
    }

    public static void updateSleepPrevention(boolean isEnabled, String reasonText) {
        if (isEnabled) {
            if (sleepPreventionAssertionId == 0) {
                IntByReference assertionIdRef = new IntByReference(0);
                CoreFoundation.CFStringRef reason = CoreFoundation.CFStringRef.createCFString((String)reasonText);
                int result = AppleIOKit.INSTANCE.IOPMAssertionCreateWithName(AppleIOKit.kIOPMAssertPreventUserIdleSystemSleep, 255, reason, assertionIdRef);
                if (result == 0) {
                    sleepPreventionAssertionId = assertionIdRef.getValue();
                    Debug.info("System sleep prevention enabled", new Object[0]);
                } else {
                    Debug.warn("IOPMAssertionCreateWithName returned {0}", result);
                }
            }
        } else if (sleepPreventionAssertionId != 0) {
            int result = AppleIOKit.INSTANCE.IOPMAssertionRelease(sleepPreventionAssertionId);
            if (result == 0) {
                Debug.info("System sleep prevention disabled", new Object[0]);
            } else {
                Debug.warn("IOPMAssertionRelease returned {0}", result);
            }
            sleepPreventionAssertionId = 0;
        }
    }
}

