/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.power;

import ch.tachyon.tunnel.common.utils.Debug;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

class CaffeinePowerManagement {
    private static final File NULL_FILE = new File("/dev/null");
    private static Boolean isSupported;
    private static Process caffeineProcess;

    CaffeinePowerManagement() {
    }

    public static synchronized boolean disableSleeping() throws IOException {
        if (Boolean.FALSE.equals(isSupported)) {
            return false;
        }
        ProcessBuilder builder = new ProcessBuilder("caffeine");
        builder.redirectError(NULL_FILE);
        builder.redirectOutput(NULL_FILE);
        builder.redirectInput(NULL_FILE);
        try {
            caffeineProcess = builder.start();
            Debug.info("Started caffeine", new Object[0]);
            isSupported = true;
        }
        catch (Throwable ex) {
            isSupported = false;
            Debug.info(ex);
            return false;
        }
        return true;
    }

    public static synchronized int enableSleeping() throws IOException, InterruptedException {
        if (Boolean.FALSE.equals(isSupported)) {
            return -2;
        }
        long timeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        while (caffeineProcess.isAlive()) {
            if (System.currentTimeMillis() > timeout) break;
            caffeineProcess.destroy();
            caffeineProcess.waitFor(100L, TimeUnit.MILLISECONDS);
        }
        try {
            if (caffeineProcess.isAlive()) {
                caffeineProcess.destroyForcibly();
                return -4;
            }
            int exitCode = caffeineProcess.exitValue();
            Debug.info("Stopped caffeine: {0}", exitCode);
            int n = exitCode;
            return n;
        }
        finally {
            caffeineProcess = null;
        }
    }

    public static synchronized boolean isSupported() {
        if (isSupported != null) {
            return isSupported;
        }
        try {
            CaffeinePowerManagement.disableSleeping();
            Thread.sleep(100L);
            int exitCode = CaffeinePowerManagement.enableSleeping();
            isSupported = exitCode >= 0;
        }
        catch (Throwable ex) {
            Debug.info(ex);
            isSupported = false;
        }
        if (isSupported == null) {
            isSupported = false;
        }
        return isSupported;
    }
}

