/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.power;

import ch.tachyon.tunnel.common.utils.Debug;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class LinuxPowerManagement {
    private static final File NULL_FILE = new File("/dev/null");
    private static Boolean isSupported;
    private static Process inhibitProcess;

    public static synchronized boolean disableSleeping(String appName, String reason) throws IOException {
        if (Boolean.FALSE.equals(isSupported)) {
            return false;
        }
        reason = String.valueOf(reason.substring(0, 1).toUpperCase()) + reason.substring(1);
        ArrayList<String> command = new ArrayList<String>();
        command.add("systemd-inhibit");
        command.add("--what=idle");
        command.add("--who=" + appName);
        command.add("--why=" + reason);
        command.add("cat");
        ProcessBuilder builder = new ProcessBuilder(command);
        builder.redirectError(NULL_FILE);
        builder.redirectOutput(NULL_FILE);
        builder.redirectInput(ProcessBuilder.Redirect.PIPE);
        try {
            inhibitProcess = builder.start();
            Debug.info("Started systemd-inhibit", new Object[0]);
            isSupported = true;
        }
        catch (Throwable ex) {
            isSupported = false;
            Debug.info(ex);
            return false;
        }
        return true;
    }

    public static synchronized int enableSleeping() throws IOException, InterruptedException {
        if (Boolean.FALSE.equals(isSupported)) {
            return -2;
        }
        long timeout = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(10L);
        while (inhibitProcess.isAlive()) {
            if (System.currentTimeMillis() > timeout) break;
            inhibitProcess.destroy();
            inhibitProcess.waitFor(100L, TimeUnit.MILLISECONDS);
        }
        try {
            if (inhibitProcess.isAlive()) {
                inhibitProcess.destroyForcibly();
                return -4;
            }
            int exitCode = inhibitProcess.exitValue();
            Debug.info("Stopped systemd-inhibit: {0}", exitCode);
            int n = exitCode;
            return n;
        }
        finally {
            inhibitProcess = null;
        }
    }

    public static synchronized boolean isSupported() {
        if (isSupported != null) {
            return isSupported;
        }
        try {
            ArrayList<String> command = new ArrayList<String>();
            command.add("systemd-inhibit");
            command.add("--version");
            ProcessBuilder builder = new ProcessBuilder(command);
            builder.redirectError(NULL_FILE);
            builder.redirectOutput(NULL_FILE);
            builder.redirectInput(NULL_FILE);
            inhibitProcess = builder.start();
            inhibitProcess.waitFor(1L, TimeUnit.SECONDS);
            Debug.info("Checked systemd-inhibit", new Object[0]);
            command = new ArrayList();
            command.add("cat");
            command.add("--version");
            builder = new ProcessBuilder(command);
            builder.redirectError(NULL_FILE);
            builder.redirectOutput(NULL_FILE);
            builder.redirectInput(NULL_FILE);
            inhibitProcess = builder.start();
            inhibitProcess.waitFor(1L, TimeUnit.SECONDS);
            Debug.info("Checked cat", new Object[0]);
            isSupported = true;
        }
        catch (Throwable ex) {
            isSupported = false;
            Debug.info(ex);
            return false;
        }
        if (isSupported == null) {
            isSupported = false;
        }
        return isSupported;
    }
}

