/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.power;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import org.corebounce.common.power.ApplePowerManagement;
import org.corebounce.common.power.CaffeinePowerManagement;
import org.corebounce.common.power.LinuxPowerManagement;
import org.corebounce.common.power.WindowsPowerManagement;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.PlatformType;

public class PowerManagement {
    private static final Set<Class<?>> sleepDisableRequests = new HashSet();

    public static boolean isSupported() {
        if (EnumSet.of(PlatformType.WINDOWS, PlatformType.MACOS).contains((Object)Platform.getPlatform())) {
            return true;
        }
        return LinuxPowerManagement.isSupported() || CaffeinePowerManagement.isSupported();
    }

    public static synchronized boolean setSleepEnabled(Class<?> forClass, boolean enabled, String who, String reason) {
        if (enabled) {
            if (!sleepDisableRequests.contains(forClass)) {
                return false;
            }
            sleepDisableRequests.remove(forClass);
            boolean result = true;
            if (sleepDisableRequests.isEmpty()) {
                result = PowerManagement.setSleepEnabled(true, who, reason);
            }
            return result;
        }
        if (sleepDisableRequests.contains(forClass)) {
            return false;
        }
        boolean result = true;
        if (sleepDisableRequests.isEmpty()) {
            result = PowerManagement.setSleepEnabled(false, who, reason);
        }
        sleepDisableRequests.add(forClass);
        return result;
    }

    private static synchronized boolean setSleepEnabled(boolean enabled, String who, String reason) {
        block11: {
            block10: {
                try {
                    if (!Platform.isWindows()) break block10;
                    WindowsPowerManagement.setSleepEnabled(enabled, String.valueOf(who) + " is " + reason);
                    return true;
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                    return false;
                }
            }
            if (!Platform.isMacOsX()) break block11;
            ApplePowerManagement.updateSleepPrevention(!enabled, String.valueOf(who) + " is " + reason);
            return true;
        }
        if (LinuxPowerManagement.isSupported()) {
            boolean result = true;
            if (enabled) {
                LinuxPowerManagement.enableSleeping();
            } else {
                result = LinuxPowerManagement.disableSleeping(who, reason);
            }
            return result;
        }
        if (CaffeinePowerManagement.isSupported()) {
            boolean result = true;
            if (enabled) {
                CaffeinePowerManagement.enableSleeping();
            } else {
                result = CaffeinePowerManagement.disableSleeping();
            }
            return result;
        }
        return false;
    }

    public static synchronized Set<Class<?>> getSleepDisableRequests() {
        return new HashSet(sleepDisableRequests);
    }
}

