/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.power;

import ch.tachyon.tunnel.common.utils.Debug;
import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.platform.win32.WTypes;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.win32.StdCallLibrary;

class WindowsPowerManagement {
    private static WindowsPowerManagement powerManagement;
    private final Kernel32 kernel32;
    private WinNT.HANDLE handle = null;

    private WindowsPowerManagement(String reason) {
        WinDef.ULONG POWER_REQUEST_CONTEXT_VERSION = new WinDef.ULONG(0L);
        WinDef.DWORD POWER_REQUEST_CONTEXT_SIMPLE_STRING = new WinDef.DWORD(1L);
        this.kernel32 = (Kernel32)Native.load((String)"kernel32", Kernel32.class);
        REASON_CONTEXT.ByReference context = new REASON_CONTEXT.ByReference();
        context.version = POWER_REQUEST_CONTEXT_VERSION;
        context.flags = POWER_REQUEST_CONTEXT_SIMPLE_STRING;
        context.simpleReasonString = new WTypes.LPWSTR(reason);
        this.handle = this.kernel32.PowerCreateRequest(context);
        if (this.handle == WinBase.INVALID_HANDLE_VALUE) {
            throw new RuntimeException("" + Native.getLastError());
        }
    }

    private void preventSleep() {
        if (!this.kernel32.PowerSetRequest(this.handle, Kernel32.PowerRequestType.PowerRequestSystemRequired.ordinal())) {
            throw new RuntimeException("PowerSetRequest() failed");
        }
        Debug.info("Prevent system sleep", new Object[0]);
    }

    private void allowSleep() {
        if (!this.kernel32.PowerClearRequest(this.handle, Kernel32.PowerRequestType.PowerRequestSystemRequired.ordinal())) {
            throw new RuntimeException("PowerClearRequest() failed");
        }
        Debug.info("Allow system sleep", new Object[0]);
    }

    public static synchronized void setSleepEnabled(boolean enabled, String reason) {
        if (enabled) {
            if (powerManagement != null) {
                powerManagement.allowSleep();
            }
            powerManagement = null;
        } else if (powerManagement == null) {
            powerManagement = new WindowsPowerManagement(reason);
            powerManagement.preventSleep();
        }
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public WinNT.HANDLE PowerCreateRequest(REASON_CONTEXT.ByReference var1);

        public boolean PowerSetRequest(WinNT.HANDLE var1, int var2);

        public boolean PowerClearRequest(WinNT.HANDLE var1, int var2);

        public static enum PowerRequestType {
            PowerRequestDisplayRequired,
            PowerRequestSystemRequired,
            PowerRequestAwayModeRequired,
            PowerRequestMaximum;

        }
    }

    @Structure.FieldOrder(value={"version", "flags", "simpleReasonString"})
    public static class REASON_CONTEXT
    extends Structure {
        public WinDef.ULONG version;
        public WinDef.DWORD flags;
        public WTypes.LPWSTR simpleReasonString;

        public static class ByReference
        extends REASON_CONTEXT
        implements Structure.ByReference {
        }
    }
}

