/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.struct;

import java.util.Map;
import org.corebounce.common.struct.CacheMap;

class CacheEntry<K, V>
implements Map.Entry<K, V> {
    private final CacheMap<K, V> cacheMap;
    private final K key;

    public CacheEntry(CacheMap<K, V> cacheMap, K key) {
        this.cacheMap = cacheMap;
        this.key = key;
    }

    @Override
    public K getKey() {
        return this.key;
    }

    @Override
    public V getValue() {
        return this.cacheMap.get(this.key);
    }

    @Override
    public V setValue(V value) {
        return this.cacheMap.put(this.key, value);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof CacheEntry) {
            CacheEntry other = (CacheEntry)obj;
            return this.key.equals(other.key);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.key.hashCode();
    }
}

