/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.struct;

import java.util.ArrayList;
import java.util.Collection;
import org.corebounce.common.struct.PublicCloneable;

public class CloningArrayList<E extends PublicCloneable<E>>
extends ArrayList<E> {
    public CloningArrayList() {
    }

    public CloningArrayList(Collection<? extends E> c) {
        super(c);
    }

    public CloningArrayList(int initialCapacity) {
        super(initialCapacity);
    }

    @Override
    public E get(int index) {
        return (E)this.clone((PublicCloneable)super.get(index));
    }

    @Override
    public E set(int index, E element) {
        return (E)((PublicCloneable)super.set(index, this.clone(element)));
    }

    @Override
    public boolean add(E e) {
        return super.add(this.clone(e));
    }

    @Override
    public void add(int index, E element) {
        super.add(index, this.clone(element));
    }

    @Override
    public E remove(int index) {
        return (E)this.clone((PublicCloneable)super.remove(index));
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        for (PublicCloneable item : c) {
            this.add((E)item);
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        for (PublicCloneable item : c) {
            this.add(index++, (E)item);
        }
        return true;
    }

    private E clone(E item) {
        if (item == null) {
            return null;
        }
        return (E)((PublicCloneable)item.clone());
    }
}

