/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.struct.skiplist;

import ch.tachyon.tunnel.common.utils.Pair;
import ch.tachyon.tunnel.common.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.corebounce.common.struct.skiplist.DefaultSkipNodeManager;
import org.corebounce.common.struct.skiplist.IAggregator;
import org.corebounce.common.struct.skiplist.ISkipNode;
import org.corebounce.common.struct.skiplist.SkipNodeManager;

public class SkipListStruct<E> {
    private final int minSkipFactor;
    private final int maxSkipFactor;
    private final SkipNodeManager<E> manager;
    private final List<Integer> skipSizes = new ArrayList<Integer>();
    private int size;
    private long totalCoverage;
    private IAggregator<E> aggregator = null;
    private int lastItemIndex = Integer.MIN_VALUE;
    private Pair<ISkipNode<E>[], ISkipNode<E>> lastItemLocation = null;
    private ISkipNode<E>[] lastEndPath = null;

    public SkipListStruct(int minSkipFactor) {
        this(minSkipFactor, new DefaultSkipNodeManager());
    }

    public SkipListStruct(int minSkipFactor, SkipNodeManager<E> manager) {
        if (minSkipFactor < 3) {
            throw new IllegalArgumentException();
        }
        this.minSkipFactor = minSkipFactor;
        this.maxSkipFactor = minSkipFactor * 2;
        this.manager = manager;
        this.init();
    }

    private void init() {
        ISkipNode<E> root = this.newNode(0);
        root.setSrcPos(0L);
        this.manager.headList().add(root);
        this.skipSizes.add(1);
    }

    private void clearCache(boolean index, boolean end) {
        if (index) {
            this.lastItemIndex = Integer.MIN_VALUE;
            this.lastItemLocation = null;
        }
        if (end) {
            this.lastEndPath = null;
        }
    }

    public IAggregator<E> getAggregator() {
        return this.aggregator;
    }

    public void setAggregator(IAggregator<E> aggregator) {
        this.aggregator = aggregator;
    }

    SkipNodeManager<E> getManager() {
        return this.manager;
    }

    ISkipNode<E> newNode(int level) {
        return this.manager.newNode(level);
    }

    ISkipNode<E> newNode(int level, E item) {
        ISkipNode<E> node = this.newNode(level);
        node.setItem(item);
        node.setWidth(1);
        node.setNbElements(1);
        return node;
    }

    public int getNblevels() {
        return this.skipSizes.size();
    }

    long getTotalCoverage() {
        return this.totalCoverage;
    }

    long getAvgCoverage(int level) {
        int levelSize = this.skipSizes.get(level);
        return (this.totalCoverage + (long)(levelSize / 2)) / (long)levelSize;
    }

    private ISkipNode<E>[] newSkipNodeArray(int size) {
        return new ISkipNode[size];
    }

    private int fillPath(int index, ISkipNode<E>[] result) {
        int startPos = 0;
        List<ISkipNode<E>> skipHeads = this.manager.headList();
        ISkipNode<E> node = skipHeads.get(skipHeads.size() - 1);
        int level = skipHeads.size() - 1;
        while (level >= 0) {
            int pos = startPos;
            while (true) {
                if (pos + node.getWidth() > index || pos + node.getWidth() == index && node.getNext() == null) break;
                pos += node.getWidth();
                node = node.getNext();
            }
            result[level] = node;
            startPos = pos;
            node = node.getDown();
            --level;
        }
        level = 0;
        while (level < result.length - 1) {
            assert (this.isChild(result[level + 1], result[level]));
            ++level;
        }
        assert (startPos <= index && startPos + this.maxSkipFactor >= index);
        return index - startPos;
    }

    private long fillPositionPath(long position, ISkipNode<E>[] result) {
        long startPos = 0L;
        List<ISkipNode<E>> skipHeads = this.manager.headList();
        ISkipNode<E> node = skipHeads.get(skipHeads.size() - 1);
        int level = skipHeads.size() - 1;
        while (level >= 0) {
            long pos = startPos;
            while (true) {
                if (pos + node.getCoverage() > position || pos + node.getCoverage() == position && node.getNext() == null) break;
                pos += node.getCoverage();
                node = node.getNext();
            }
            result[level] = node;
            startPos = pos;
            node = node.getDown();
            --level;
        }
        level = 0;
        while (level < result.length - 1) {
            assert (this.isChild(result[level + 1], result[level]));
            ++level;
        }
        assert (startPos <= position);
        return position - startPos;
    }

    public ISkipNode<E>[] indexToPath(int index) {
        ISkipNode<E>[] result = this.newSkipNodeArray(this.skipSizes.size());
        this.fillPath(index, result);
        return result;
    }

    public ISkipNode<E>[] positionToPath(long position) {
        ISkipNode<E>[] result = this.newSkipNodeArray(this.skipSizes.size());
        this.fillPositionPath(position, result);
        return result;
    }

    public Pair<ISkipNode<E>[], ISkipNode<E>> indexToLocation(int index) {
        if (index < 0 || index > this.size) {
            throw new IllegalArgumentException();
        }
        if (index == 0) {
            ISkipNode<E>[] path = this.newSkipNodeArray(this.skipSizes.size());
            int i = 0;
            while (i < path.length) {
                path[i] = this.manager.headList().get(i);
                ++i;
            }
            ISkipNode<E> node = this.manager.getFirst();
            Pair<ISkipNode<E>[], ISkipNode<E>> result = new Pair<ISkipNode<E>[], ISkipNode<E>>(path, node);
            this.lastItemIndex = index;
            this.lastItemLocation = result;
            return result;
        }
        if (index == this.lastItemIndex) {
            return this.lastItemLocation;
        }
        if (index == this.lastItemIndex + 1) {
            ISkipNode<E>[] path = this.lastItemLocation.getFirst();
            ISkipNode<E> node = this.lastItemLocation.getSecond();
            node = node.getNext();
            ISkipNode<E> parent = path[0];
            ISkipNode<E> child = node;
            ISkipNode<E> nextParent = parent.getNext();
            int level = 0;
            while (child != null && nextParent != null && nextParent.getDown().equals(child)) {
                path[level] = nextParent;
                child = path[level];
                if (++level >= path.length) break;
                parent = path[level];
                nextParent = parent.getNext();
            }
            this.lastItemLocation = new Pair<ISkipNode<ISkipNode<E>[]>[], ISkipNode<ISkipNode<E>[]>>(path, node);
            this.lastItemIndex = index;
            return this.lastItemLocation;
        }
        if (index == this.lastItemIndex - 1) {
            ISkipNode<E>[] path = this.lastItemLocation.getFirst();
            ISkipNode<E> node = this.lastItemLocation.getSecond();
            ISkipNode<E> parent = path[0];
            ISkipNode<E> child = node;
            int level = 0;
            while (child != null && level < path.length && parent.getDown() == child) {
                child = path[level];
                path[level] = parent.getPrev();
                if (++level >= path.length) break;
                parent = path[level];
            }
            node = node.getPrev();
            this.lastItemLocation = new Pair<ISkipNode<ISkipNode<E>[]>[], ISkipNode<ISkipNode<E>[]>>(path, node);
            this.lastItemIndex = index;
            return this.lastItemLocation;
        }
        if (index == this.size && this.lastEndPath != null) {
            assert (this.lastEndPath.length == this.skipSizes.size());
            int i = 0;
            while (i < this.lastEndPath.length) {
                assert (this.lastEndPath[i].getNext() == null);
                ++i;
            }
            Pair<ISkipNode<E>[], Object> result = new Pair<ISkipNode<E>[], Object>(this.lastEndPath, null);
            return result;
        }
        Pair<ISkipNode<E>[], ISkipNode<E>> result = this.indexToLocation0(index);
        assert (index == this.size == (result.getSecond() == null));
        if (result.getSecond() != null) {
            this.lastItemLocation = result;
            this.lastItemIndex = index;
        } else {
            assert (index == this.size);
            this.lastEndPath = result.getFirst();
        }
        return result;
    }

    private Pair<ISkipNode<E>[], ISkipNode<E>> indexToLocation0(int index) {
        ISkipNode<E>[] path = this.newSkipNodeArray(this.skipSizes.size());
        int count = this.fillPath(index, path);
        ISkipNode<E> node = path[0].getDown();
        int i = 0;
        while (i < count) {
            node = node.getNext();
            ++i;
        }
        Pair<ISkipNode<E>[], ISkipNode<E>> result = new Pair<ISkipNode<E>[], ISkipNode<E>>(path, node);
        return result;
    }

    public Pair<ISkipNode<E>[], ISkipNode<E>> positionToLocation(long position) {
        ISkipNode<E>[] path = this.newSkipNodeArray(this.skipSizes.size());
        long count = this.fillPositionPath(position, path);
        ISkipNode<E> node = path[0].getDown();
        while (count >= node.getCoverage()) {
            count -= node.getCoverage();
            node = node.getNext();
        }
        Pair<ISkipNode<E>[], ISkipNode<E>> result = new Pair<ISkipNode<E>[], ISkipNode<E>>(path, node);
        return result;
    }

    public int positionToIndex(long position) {
        int result = 0;
        long startPos = 0L;
        List<ISkipNode<E>> skipHeads = this.manager.headList();
        ISkipNode<E> node = skipHeads.get(skipHeads.size() - 1);
        int level = skipHeads.size() - 1;
        while (level >= 0) {
            long pos = startPos;
            while (pos + node.getCoverage() <= position && (pos + node.getCoverage() != position || node.getNext() != null)) {
                pos += node.getCoverage();
                result += node.getWidth();
                node = node.getNext();
            }
            startPos = pos;
            node = node.getDown();
            --level;
        }
        assert (node.getDown() == null);
        long remaining = position - startPos;
        while (remaining >= node.getCoverage()) {
            remaining -= node.getCoverage();
            ++result;
            node = node.getNext();
        }
        return result;
    }

    boolean isChild(ISkipNode<E> parent, ISkipNode<E> child) {
        ISkipNode<E> down = parent.getDown();
        int i = 0;
        while (i < parent.getNbElements()) {
            if (down.equals(child)) {
                return true;
            }
            down = down.getNext();
            ++i;
        }
        return false;
    }

    private void insertAfter(ISkipNode<E> node, ISkipNode<E> newNode) {
        ISkipNode<E> next = node.getNext();
        node.setNext(newNode);
        newNode.setPrev(node);
        newNode.setNext(next);
        if (next != null) {
            next.setPrev(newNode);
        }
    }

    void removeNode(ISkipNode<E> node) {
        if (node.getPrev() != null) {
            node.getPrev().setNext(node.getNext());
        }
        if (node.getNext() != null) {
            node.getNext().setPrev(node.getPrev());
        }
        node.setNext(null);
        node.setPrev(null);
        node.dispose();
    }

    public void itemUpdated(long deltaCoverage) {
        this.totalCoverage += deltaCoverage;
    }

    public void itemAdded(ISkipNode<E>[] path, long itemCoverage, boolean isAtEnd) {
        this.clearCache(true, !isAtEnd);
        List<ISkipNode<ISkipNode<E>>> skipHeads = this.manager.headList();
        ISkipNode<E>[] iSkipNodeArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            ISkipNode<E> node = iSkipNodeArray[n2];
            node.setWidth(node.getWidth() + 1);
            node.setCoverage(node.getCoverage() + itemCoverage);
            this.clearAggregate(node);
            ++n2;
        }
        ++this.size;
        this.totalCoverage += itemCoverage;
        int level = 0;
        ISkipNode<E> node = path[level];
        node.setNbElements(node.getNbElements() + 1);
        while (node.getNbElements() >= this.maxSkipFactor) {
            this.clearCache(false, true);
            int nbTotalElements = node.getNbElements();
            assert (nbTotalElements == this.maxSkipFactor);
            node.setNbElements(nbTotalElements / 2);
            ISkipNode<E> nextDown = this.recalcWidth(node);
            ISkipNode<E> nextNode = this.newNode(level);
            nextNode.setSrcPos(node.getSrcPos() + node.getCoverage());
            nextNode.setDown(nextDown);
            nextNode.setNbElements(nbTotalElements - node.getNbElements());
            this.recalcWidth(nextNode);
            this.insertAfter(node, nextNode);
            this.skipSizes.set(level, this.skipSizes.get(level) + 1);
            if (level == path.length - 1 && this.skipSizes.get(level) > 1) {
                ISkipNode<E> newHead = this.newNode(level + 1);
                newHead.setSrcPos(0L);
                newHead.setDown(skipHeads.get(level));
                newHead.setNbElements(this.skipSizes.get(level));
                this.recalcWidth(newHead);
                skipHeads.add(newHead);
                this.skipSizes.add(1);
            }
            this.ensureAggregate(node);
            this.ensureAggregate(nextNode);
            if (++level >= path.length) break;
            node = path[level];
            node.setNbElements(node.getNbElements() + 1);
        }
    }

    public void itemRemoved(ISkipNode<E>[] path, long itemCoverage) {
        this.clearCache(true, true);
        List<ISkipNode<E>> skipHeads = this.manager.headList();
        ISkipNode<E>[] iSkipNodeArray = path;
        int n = path.length;
        int n2 = 0;
        while (n2 < n) {
            ISkipNode<E> node = iSkipNodeArray[n2];
            node.setWidth(node.getWidth() - 1);
            node.setCoverage(node.getCoverage() - itemCoverage);
            this.clearAggregate(node);
            ++n2;
        }
        --this.size;
        this.totalCoverage -= itemCoverage;
        int level = 0;
        ISkipNode<E> node = path[level];
        node.setNbElements(node.getNbElements() - 1);
        boolean nodeRemoved = false;
        while (this.isTooSmall(node)) {
            this.mergeWithNext(path, node, level);
            nodeRemoved = true;
            if (++level >= path.length) break;
            node = path[level];
            node.setNbElements(node.getNbElements() - 1);
        }
        while (nodeRemoved && this.skipSizes.size() > 1) {
            int topLevel = this.skipSizes.size() - 1;
            int topLevelSize = this.skipSizes.get(topLevel);
            int subLevelSize = this.skipSizes.get(topLevel - 1);
            if (subLevelSize == 1) {
                assert (topLevelSize == 1 || this.size == 0 && topLevelSize == 0);
                this.skipSizes.remove(topLevel);
                skipHeads.remove(topLevel);
                continue;
            }
            nodeRemoved = false;
        }
    }

    private boolean isTooSmall(ISkipNode<E> node) {
        ISkipNode<E> next = node.getNext();
        if (next != null && node.getNbElements() + next.getNbElements() < this.minSkipFactor) {
            return true;
        }
        return node.getNbElements() <= 0;
    }

    private void mergeWithNext(ISkipNode<E>[] path, ISkipNode<E> node, int level) {
        List<ISkipNode<ISkipNode<E>>> skipHeads = this.manager.headList();
        ISkipNode<E> next = node.getNext();
        if (node.getNbElements() > 0 || node.getWidth() > 0 || node.getCoverage() > 0L) {
            next.setDown(node.getDown());
            next.setNbElements(node.getNbElements() + next.getNbElements());
            next.setWidth(node.getWidth() + next.getWidth());
            next.setCoverage(node.getCoverage() + next.getCoverage());
            this.clearAggregate(next);
        }
        if (level < path.length - 1) {
            ISkipNode<E> upper = path[level + 1];
            if (upper.getDown().equals(node)) {
                upper.setDown(next);
            }
            ISkipNode<E> parent = upper;
            ISkipNode<E> node1 = node;
            ISkipNode<E> node2 = next;
            int level0 = level;
            int width = node1.getWidth();
            long coverage = node1.getCoverage();
            while (node2 != null && !this.isChild(parent, node2)) {
                assert (Utils.eq(parent.getNext().getDown(), node2));
                parent.setWidth(parent.getWidth() - width);
                parent.setCoverage(parent.getCoverage() - coverage);
                this.clearAggregate(parent);
                ISkipNode<E> nextParent = parent.getNext();
                nextParent.setWidth(nextParent.getWidth() + width);
                nextParent.setCoverage(nextParent.getCoverage() + coverage);
                this.clearAggregate(nextParent);
                if (++level0 >= path.length - 1) break;
                node1 = parent;
                node2 = nextParent;
                parent = path[level0 + 1];
                assert (this.isChild(parent, node1));
            }
        }
        this.skipSizes.set(level, this.skipSizes.get(level) - 1);
        if (skipHeads.get(level).equals(node)) {
            skipHeads.set(level, next);
            if (level == 0 && next == null) {
                assert (this.size == 0);
                assert (this.skipSizes.get(level) == 0);
                ISkipNode<E> root = this.newNode(0);
                root.setSrcPos(0L);
                skipHeads.set(0, root);
                this.skipSizes.set(0, 1);
            }
        }
        this.removeNode(node);
    }

    private ISkipNode<E> recalcWidth(ISkipNode<E> node) {
        int nbDownElements = node.getNbElements();
        ISkipNode<E> down = node.getDown();
        if (down == null) {
            node.setWidth(nbDownElements);
            node.setCoverage(nbDownElements);
            this.clearAggregate(node);
            return null;
        }
        int width = 0;
        long coverage = 0L;
        int i = 0;
        while (i < nbDownElements) {
            width += down.getWidth();
            coverage += down.getCoverage();
            down = down.getNext();
            ++i;
        }
        node.setWidth(width);
        node.setCoverage(coverage);
        this.clearAggregate(node);
        return down;
    }

    void clearAggregate(ISkipNode<E> node) {
        node.setAggregate(null);
    }

    void ensureAggregate(ISkipNode<E> node) {
        if (this.aggregator != null && node.getAggregate() == null) {
            ArrayList<E> items = new ArrayList<E>();
            ISkipNode<E> childNode = node.getDown();
            boolean isLevel0 = false;
            int i = 0;
            while (i < node.getNbElements()) {
                E item;
                if (isLevel0 || childNode.getDown() == null) {
                    item = childNode.getItem();
                    isLevel0 = true;
                } else {
                    this.ensureAggregate(childNode);
                    item = childNode.getAggregate();
                }
                items.add(item);
                childNode = childNode.getNext();
                ++i;
            }
            E newItem = this.aggregator.aggregate(items);
            node.setAggregate(newItem);
        }
    }

    public int getSize() {
        return this.size;
    }

    public void assertCoherency() {
        assert (this.isCoherent());
    }

    private boolean isCoherent() {
        List<ISkipNode<E>> skipHeads = this.manager.headList();
        int level = 0;
        while (level < skipHeads.size()) {
            int nbNodes = 0;
            int totalWidth = 0;
            long totalCoverage = 0L;
            ISkipNode<E> node = skipHeads.get(level);
            while (node != null) {
                if (level == 0) assert (node.getNbElements() == node.getWidth());
                ++nbNodes;
                totalWidth += node.getWidth();
                totalCoverage += node.getCoverage();
                node = node.getNext();
            }
            assert (totalWidth == this.size);
            assert (totalCoverage == this.totalCoverage);
            assert (this.skipSizes.get(level).equals(nbNodes) || this.size == 0 && nbNodes == 1 && level == 0);
            ++level;
        }
        return skipHeads.size() == this.skipSizes.size();
    }

    void checkNodeDown(ISkipNode<E> node) {
        if (node.getDown() == null) {
            return;
        }
        ISkipNode<E> child = node.getDown();
        int nbDowns = 0;
        int downWidth = 0;
        long downCoverage = 0L;
        while (nbDowns < node.getNbElements()) {
            ++nbDowns;
            downWidth += child.getWidth();
            downCoverage += child.getCoverage();
            child = child.getNext();
        }
        if (node.getNext() == null ? !$assertionsDisabled && child != null : !$assertionsDisabled && !node.getNext().getDown().equals(child)) {
            throw new AssertionError();
        }
        assert (node.getWidth() == downWidth);
        assert (node.getCoverage() == downCoverage);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("sizes=");
        result.append(this.skipSizes);
        int nbNodes = 0;
        for (int size : this.skipSizes) {
            nbNodes += size;
        }
        result.append(",nbNodes=");
        result.append(nbNodes);
        return result.toString();
    }
}

