/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

import ch.tachyon.tunnel.common.utils.Debug;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class AppUtils {
    private static String appName;

    public static void setAppName(String appName) {
        AppUtils.appName = appName;
    }

    public static String getAppName() {
        return appName == null ? "" : appName;
    }

    public static File getApplicationDirectory(Class<?> mainClass) {
        try {
            URI codeLocation = mainClass.getProtectionDomain().getCodeSource().getLocation().toURI();
            File location = new File(codeLocation);
            if (location.isFile() && location.getName().endsWith(".jar")) {
                return location.getParentFile();
            }
            return location;
        }
        catch (Exception exception) {
            return AppUtils.getApplicationDirectory0(mainClass);
        }
    }

    private static File getApplicationDirectory0(Class<?> mainClass) {
        String ourJar;
        File file;
        String classPaths = System.getProperty("java.class.path");
        String[] cpArr = classPaths.split("\\" + File.pathSeparator);
        if (cpArr != null && cpArr.length == 1 && (file = new File(ourJar = cpArr[0])).exists() && file.isFile()) {
            return file.getAbsoluteFile().getParentFile();
        }
        if (cpArr != null && cpArr.length >= 1) {
            String className = mainClass.getName();
            String fileName = String.valueOf(className.replace('.', '/')) + ".class";
            String[] stringArray = cpArr;
            int n = cpArr.length;
            int n2 = 0;
            while (n2 < n) {
                String classPath = stringArray[n2];
                File path = new File(classPath);
                if (path.isDirectory()) {
                    File classFile = new File(path, fileName);
                    if (classFile.exists() && classFile.isFile()) {
                        return path.getAbsoluteFile();
                    }
                } else if (path.isFile() && path.getName().endsWith(".jar")) {
                    JarFile jarFile = null;
                    try {
                        jarFile = new JarFile(path);
                        ZipEntry entry = jarFile.getEntry(fileName);
                        if (entry != null) {
                            File file2 = path.getAbsoluteFile().getParentFile();
                            return file2;
                        }
                    }
                    catch (IOException ex) {
                        Debug.error(ex);
                    }
                    finally {
                        if (jarFile != null) {
                            try {
                                jarFile.close();
                            }
                            catch (IOException ex) {
                                Debug.error(ex);
                            }
                        }
                    }
                }
                ++n2;
            }
        }
        return new File(System.getProperty("user.dir"));
    }
}

