/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BufferPool {
    private final Map<IntRef, List<float[]>> pool = new HashMap<IntRef, List<float[]>>();
    private final IntRef index = new IntRef(0);

    public List<float[]> getFreeList(int length) {
        this.index.set(length);
        List<float[]> result = this.pool.get(this.index);
        if (result == null) {
            result = new ArrayList<float[]>();
            this.pool.put(new IntRef(length), result);
        }
        return result;
    }

    public static float[] removeOrCreate(List<float[]> freeList, int length) {
        if (freeList.isEmpty()) {
            return new float[length];
        }
        float[] result = freeList.remove(0);
        if (result.length != length) {
            throw new IllegalStateException();
        }
        return result;
    }

    static class IntRef {
        private int value;

        public IntRef(int value) {
            this.value = value;
        }

        public int get() {
            return this.value;
        }

        public void set(int value) {
            this.value = value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.value;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            IntRef other = (IntRef)obj;
            return this.value == other.value;
        }

        public String toString() {
            return "IntRef [value=" + this.value + "]";
        }
    }
}

