/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

import ch.tachyon.tunnel.common.utils.Debug;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Stack;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.corebounce.common.utils.AppUtils;
import org.corebounce.common.utils.StringUtils;

public class ClassLoaderUtils {
    private static final Stack<Object> keyStack = new Stack();
    private static final Stack<ClassLoader> classLoaderStack = new Stack();
    private static final Stack<LinkedHashSet<String>> classPathStack = new Stack();
    private static ClassLoader curClassLoader = null;
    private static Set<String> addedClassPaths = new LinkedHashSet<String>();

    private static URL file2Url(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public static synchronized void pushClassPathFiles(Object key, File ... files) {
        URL[] urls = new URL[files.length];
        int i = 0;
        while (i < files.length) {
            urls[i] = ClassLoaderUtils.file2Url(files[i]);
            ++i;
        }
        ClassLoader currentThreadClassLoader = Thread.currentThread().getContextClassLoader();
        keyStack.push(key);
        classLoaderStack.push(currentThreadClassLoader);
        classPathStack.push(new LinkedHashSet<String>(addedClassPaths));
        if (files.length > 0) {
            URLClassLoader urlClassLoader = new URLClassLoader(urls, currentThreadClassLoader);
            curClassLoader = urlClassLoader;
            Thread.currentThread().setContextClassLoader(urlClassLoader);
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                addedClassPaths.add(file.getAbsolutePath());
                ++n2;
            }
        } else {
            curClassLoader = currentThreadClassLoader;
        }
    }

    public static int pushAllJarFiles(Object key, File directory) {
        ArrayList<File> jarFiles = new ArrayList<File>();
        if (directory.isDirectory()) {
            File[] fileArray = directory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && file.getName().toLowerCase().endsWith(".jar")) {
                    jarFiles.add(file);
                }
                ++n2;
            }
        }
        ClassLoaderUtils.pushClassPathFiles(key, jarFiles.toArray(new File[jarFiles.size()]));
        return jarFiles.size();
    }

    public static void ensureClassPath() {
        if (curClassLoader == null) {
            return;
        }
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        if (!curClassLoader.equals(threadClassLoader)) {
            Thread.currentThread().setContextClassLoader(curClassLoader);
        }
    }

    public static synchronized boolean popClassPathFiles(Object key) {
        Object headKey = keyStack.peek();
        if (!headKey.equals(key)) {
            return false;
        }
        keyStack.pop();
        curClassLoader = classLoaderStack.pop();
        addedClassPaths = classPathStack.pop();
        Thread.currentThread().setContextClassLoader(curClassLoader);
        return true;
    }

    private static boolean containsURL(URL[] urls, URL url) {
        int i = 0;
        while (i < urls.length) {
            String urlStr;
            URL element = urls[i];
            String elementStr = element.toExternalForm();
            if (elementStr.equals(urlStr = url.toExternalForm())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static synchronized void addAllJarsToClassPath(File directory) {
        ClassLoader classLoader;
        ArrayList<File> jarFiles = new ArrayList<File>();
        if (directory.isDirectory()) {
            File[] fileArray = directory.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isFile() && file.getName().toLowerCase().endsWith(".jar")) {
                    jarFiles.add(file);
                }
                ++n2;
            }
        }
        if (!((classLoader = ClassLoaderUtils.class.getClassLoader()) instanceof URLClassLoader)) {
            Debug.warn("Root ClassLoader is not an URLClassLoader.Please add .jar files from \"{0}\" to the classpath manually using the -cp option in case classes cannot be found.", directory);
            return;
        }
        URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
        for (File file : jarFiles) {
            URL url = ClassLoaderUtils.file2Url(file);
            try {
                if (ClassLoaderUtils.containsURL(urlClassLoader.getURLs(), url)) continue;
                Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
                addURL.setAccessible(true);
                addURL.invoke((Object)urlClassLoader, url);
                addURL.setAccessible(false);
                addedClassPaths.add(file.getAbsolutePath());
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static synchronized Collection<String> getClassPath(Class<?> mainClass) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        String rootClassPath = System.getProperty("java.class.path");
        String[] classPaths = rootClassPath.split("\\" + File.pathSeparator);
        result.addAll(Arrays.asList(classPaths));
        File appDir = AppUtils.getApplicationDirectory(mainClass);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Enumeration<URL> iter = cl.getResources("META-INF/MANIFEST.MF");
            while (iter.hasMoreElements()) {
                String[] cps;
                URL url = iter.nextElement();
                InputStream input = url.openStream();
                Manifest manifest = new Manifest(input);
                Attributes attrs = manifest.getMainAttributes();
                String items = attrs.getValue("Class-Path");
                if (items == null) continue;
                String[] stringArray = cps = items.split("[\\s]");
                int n = cps.length;
                int n2 = 0;
                while (n2 < n) {
                    String cp = stringArray[n2];
                    if (StringUtils.isNotBlank(cp)) {
                        File file = new File(appDir, cp);
                        result.add(file.getAbsolutePath());
                    }
                    ++n2;
                }
            }
        }
        catch (IOException ex) {
            Debug.warn(ex);
        }
        result.addAll(addedClassPaths);
        return result;
    }
}

