/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

import ch.tachyon.tunnel.common.utils.Debug;
import ch.tachyon.tunnel.common.utils.Monitor;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.List;
import org.corebounce.common.log.EventTrace;
import org.corebounce.common.log.LogEntry;
import org.corebounce.common.log.LogFormatter;
import org.corebounce.common.utils.Platform;
import org.corebounce.common.utils.ReflectUtils;
import org.corebounce.common.utils.ThreadUtils;

public class DeadlockDetector
extends Thread {
    private static final int DETECTION_PERIOD = 30000;
    private ThreadMXBean threadMxBean;
    private final Callback callback;
    private static final Object lock = new Monitor("DeadlockDetector");

    public DeadlockDetector(Callback callback) {
        super("Deadlock detector");
        super.setPriority(1);
        super.setDaemon(true);
        this.callback = callback;
        try {
            this.threadMxBean = ManagementFactory.getThreadMXBean();
        }
        catch (Throwable ex) {
            Debug.error(ex);
            Debug.warn("Deadlock detection is not supported (see previous error) and has been disabled", new Object[0]);
            this.threadMxBean = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (this.threadMxBean != null) {
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait(30000L);
                }
                catch (InterruptedException ex) {
                    Debug.warn(ex);
                }
            }
            try {
                if (!this.detectDeadlocks()) continue;
            }
            catch (Throwable ex) {
                Debug.error(ex);
                Debug.warn("Deadlock detection is not supported (see previous error) and has been disabled", new Object[0]);
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detectDeadlocksNow() {
        Object object = lock;
        synchronized (object) {
            lock.notifyAll();
        }
    }

    private boolean detectDeadlocks() {
        long[] ids = this.threadMxBean.findMonitorDeadlockedThreads();
        if (ids == null || ids.length == 0) {
            return false;
        }
        ThreadInfo[] threads = Platform.isBelowJava16() ? this.threadMxBean.getThreadInfo(ids, Integer.MAX_VALUE) : (ThreadInfo[])ReflectUtils.invokeMethod(ThreadMXBean.class, this.threadMxBean, "getThreadInfo", new Class[]{long[].class, Boolean.TYPE, Boolean.TYPE}, new Object[]{ids, true, true});
        if (threads == null) {
            return false;
        }
        this.callback.threadsDeadlocked(threads);
        return true;
    }

    public static void main(String[] args) {
        LogFormatter.setup();
        DeadlockDetector dld = new DeadlockDetector(new DefaultCallback());
        dld.start();
        final Object lock1 = new Object();
        final Object lock2 = new Object();
        Thread t1 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock1;
                synchronized (object) {
                    ThreadUtils.sleep(2000);
                    Object object2 = lock2;
                    synchronized (object2) {
                        ThreadUtils.sleep(2000);
                    }
                }
            }
        };
        Thread t2 = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = lock2;
                synchronized (object) {
                    ThreadUtils.sleep(2000);
                    Object object2 = lock1;
                    synchronized (object2) {
                        ThreadUtils.sleep(2000);
                    }
                }
            }
        };
        Debug.debug("Starting thread 1", new Object[0]);
        Debug.debug("Starting thread 2", new Object[0]);
        t1.start();
        t2.start();
        ThreadUtils.join(t1, 10000L);
        ThreadUtils.join(t2, 10000L);
    }

    public static interface Callback {
        public void threadsDeadlocked(ThreadInfo[] var1);
    }

    public static class DefaultCallback
    implements Callback {
        @Override
        public void threadsDeadlocked(ThreadInfo[] threads) {
            System.err.println("*** Deadlock detected ***");
            ThreadInfo[] threadInfoArray = threads;
            int n = threads.length;
            int n2 = 0;
            while (n2 < n) {
                ThreadInfo thread = threadInfoArray[n2];
                if (thread != null) {
                    long blockedBy;
                    String lockName;
                    int n3;
                    System.err.println("Thread " + thread.getThreadId() + ": " + thread.getThreadName());
                    System.err.println(" Stack Trace:");
                    StackTraceElement[] stack = thread.getStackTrace();
                    if (stack != null) {
                        StackTraceElement[] stackTraceElementArray = stack;
                        n3 = stack.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            StackTraceElement item = stackTraceElementArray[n4];
                            System.err.println("  " + item.toString());
                            ++n4;
                        }
                    }
                    if (!Platform.isBelowJava16()) {
                        System.err.println(" Monitors:");
                        Object[] monitors = (Object[])ReflectUtils.invokeMethod(ThreadInfo.class, thread, "getLockedMonitors", new Class[0], new Object[0]);
                        if (monitors != null) {
                            Object[] objectArray = monitors;
                            int n5 = monitors.length;
                            n3 = 0;
                            while (n3 < n5) {
                                Object monitor = objectArray[n3];
                                System.err.println("  " + monitor.toString());
                                ++n3;
                            }
                        }
                        System.err.println(" Locks:");
                        Object[] locks = (Object[])ReflectUtils.invokeMethod(ThreadInfo.class, thread, "getLockedSynchronizers", new Class[0], new Object[0]);
                        if (locks != null) {
                            Object[] objectArray = locks;
                            int n6 = locks.length;
                            int n7 = 0;
                            while (n7 < n6) {
                                Object lock = objectArray[n7];
                                System.err.println("  " + lock.toString());
                                ++n7;
                            }
                        }
                    }
                    if ((lockName = thread.getLockName()) != null) {
                        System.err.println(" Blocked on " + lockName);
                    }
                    if ((blockedBy = thread.getLockOwnerId()) >= 0L) {
                        System.err.println(" Blocked by thread " + blockedBy);
                    }
                }
                ++n2;
            }
            System.err.println("*** Event log ***");
            List<LogEntry> logEntries = EventTrace.getLogEntries();
            for (LogEntry entry : logEntries) {
                System.err.println(entry.toString());
            }
            System.err.println("*** End of Deadlock report ***");
        }
    }
}

