/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

import ch.tachyon.tunnel.common.utils.Debug;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;

public class MemoryModel {
    private static final boolean IS_32BIT;
    private static final boolean IS_UNCOMPRESSED;
    private static final double RATIO_32BIT = 0.81;
    private static final double RATIO_UNCOMPRESSED = 1.13;

    static {
        boolean uncompressed;
        String dataModel = System.getProperty("sun.arch.data.model");
        IS_32BIT = "32".equals(dataModel);
        if (IS_32BIT) {
            uncompressed = true;
        } else {
            try {
                long maxMemory = 0L;
                for (MemoryPoolMXBean mp : ManagementFactory.getMemoryPoolMXBeans()) {
                    long size = mp.getUsage().getMax();
                    if (size <= 0L) continue;
                    maxMemory += size;
                }
                uncompressed = maxMemory >= 0x800000000L;
            }
            catch (Throwable ex) {
                Debug.warn(ex);
                uncompressed = Runtime.getRuntime().maxMemory() >= 0x780000000L;
            }
        }
        IS_UNCOMPRESSED = uncompressed;
    }

    public static double getMemoryModelRatio() {
        if (IS_32BIT) {
            return 0.81;
        }
        if (IS_UNCOMPRESSED) {
            return 1.13;
        }
        return 1.0;
    }

    public static boolean is32Bit() {
        return IS_32BIT;
    }

    public static boolean isUncompressed() {
        return IS_UNCOMPRESSED;
    }

    public static double kb(double value) {
        return value * 1000.0;
    }

    public static double mb(double value) {
        return MemoryModel.kb(value) * 1000.0;
    }

    public static double gb(double value) {
        return MemoryModel.mb(value) * 1000.0;
    }
}

