/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

import ch.tachyon.tunnel.common.AudioStreamFormat;
import ch.tachyon.tunnel.common.IMultiChanAudioSource;
import org.corebounce.common.utils.BufferPool;

public class MultiChanAudioSourceFork {
    private static final boolean LOG_ENLARGE = false;
    private static final boolean LOG_READ = false;
    private final IMultiChanAudioSource target;
    private final int nbReaders;
    private final int nbChannels;
    private final IMultiChanAudioSource[] sources;
    private final String name;
    private final String[] readerNames;
    private float[][] buffer;
    private int size;
    private int capacity;
    private int[] indexes;
    private BufferPool pool;
    private float[][] toAdd;

    public MultiChanAudioSourceFork(IMultiChanAudioSource target, int nbReaders, int nbChannels, String name, String[] readerNames) {
        this.target = target;
        this.nbReaders = nbReaders;
        this.nbChannels = nbChannels;
        this.name = name;
        this.readerNames = readerNames;
        if (nbReaders != readerNames.length) {
            throw new IllegalArgumentException();
        }
        this.indexes = new int[nbReaders];
        this.buffer = new float[nbChannels][0];
        this.size = 0;
        this.capacity = 0;
        this.sources = new IMultiChanAudioSource[nbReaders];
        int i = 0;
        while (i < nbReaders) {
            this.sources[i] = new ReaderSource(i);
            ++i;
        }
        this.toAdd = new float[nbChannels][];
    }

    public IMultiChanAudioSource getSource(int readerNum) {
        return this.sources[readerNum];
    }

    private int readSamples(int readerNum, float[][] output) {
        int read;
        int remaining;
        int amount = output[0].length;
        if (this.indexes[readerNum] + amount > this.size) {
            int minIndex = this.capacity;
            int i = 0;
            while (i < this.nbReaders) {
                if (this.indexes[i] < minIndex) {
                    minIndex = this.indexes[i];
                }
                ++i;
            }
            if (minIndex > 0) {
                int chan = 0;
                while (chan < this.nbChannels) {
                    System.arraycopy(this.buffer[chan], minIndex, this.buffer[chan], 0, this.size - minIndex);
                    ++chan;
                }
                this.size -= minIndex;
                i = 0;
                while (i < this.nbReaders) {
                    int n = i++;
                    this.indexes[n] = this.indexes[n] - minIndex;
                }
            }
        }
        if (this.indexes[readerNum] + amount > this.capacity) {
            remaining = Math.max(this.indexes[readerNum] + amount - this.size, this.capacity);
            float[][] toAdd = new float[this.nbChannels][remaining];
            read = this.target.readSamples(toAdd);
            if (read > 0) {
                float[][] newBuffer = new float[this.nbChannels][this.size + read];
                int chan = 0;
                while (chan < this.nbChannels) {
                    System.arraycopy(this.buffer[chan], 0, newBuffer[chan], 0, this.size);
                    System.arraycopy(toAdd[chan], 0, newBuffer[chan], this.size, read);
                    ++chan;
                }
                this.buffer = newBuffer;
                this.capacity = newBuffer[0].length;
                this.size += read;
            }
        } else if (this.indexes[readerNum] + amount > this.size) {
            remaining = this.capacity - this.size;
            Object freeList = null;
            int chan = 0;
            while (chan < this.nbChannels) {
                this.toAdd[chan] = new float[remaining];
                ++chan;
            }
            read = this.target.readSamples(this.toAdd);
            if (read > 0) {
                int chan2 = 0;
                while (chan2 < this.nbChannels) {
                    System.arraycopy(this.toAdd[chan2], 0, this.buffer[chan2], this.size, read);
                    ++chan2;
                }
                this.size += read;
            }
        }
        if (this.indexes[readerNum] + amount > this.size) {
            amount = this.size - this.indexes[readerNum];
        }
        int chan = 0;
        while (chan < this.nbChannels) {
            System.arraycopy(this.buffer[chan], this.indexes[readerNum], output[chan], 0, amount);
            ++chan;
        }
        int n = readerNum;
        this.indexes[n] = this.indexes[n] + amount;
        return amount;
    }

    class ReaderSource
    implements IMultiChanAudioSource {
        private final int readerNum;

        public ReaderSource(int readerNum) {
            this.readerNum = readerNum;
        }

        @Override
        public AudioStreamFormat getAudioFormat() {
            return MultiChanAudioSourceFork.this.target.getAudioFormat();
        }

        @Override
        public int readSamples(float[][] target) {
            return MultiChanAudioSourceFork.this.readSamples(this.readerNum, target);
        }

        @Override
        public void close() {
        }
    }
}

