/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

import ch.tachyon.tunnel.common.utils.Debug;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import org.corebounce.common.gui.image.IconLoader;
import org.corebounce.common.utils.PlatformType;
import org.corebounce.common.utils.StringUtils;

public class Platform {
    private static int javaMajorVersion;
    private static int javaMinorVersion;
    private static String javaRevision;
    private static String osName;
    private static boolean interpreted;
    private static boolean singleCore;

    static {
        String javaVersion = System.getProperty("java.version");
        try {
            String[] tokens = javaVersion.split("\\.");
            if (tokens.length == 1) {
                javaMajorVersion = 1;
                javaMinorVersion = Integer.parseInt(Platform.keepDigitsOnly(tokens[0]));
                javaRevision = "";
            } else {
                javaMajorVersion = Integer.parseInt(Platform.keepDigitsOnly(tokens[0]));
                javaMinorVersion = Integer.parseInt(Platform.keepDigitsOnly(tokens[1]));
                if (tokens.length >= 3) {
                    javaRevision = tokens[2];
                }
            }
            try {
                RuntimeMXBean runtimeMxBean = ManagementFactory.getRuntimeMXBean();
                List<String> arguments = runtimeMxBean.getInputArguments();
                interpreted = arguments.contains("-Xint");
            }
            catch (Throwable t) {
                Debug.warn(t);
            }
        }
        catch (Exception ex) {
            Debug.error(ex);
        }
        singleCore = Runtime.getRuntime().availableProcessors() <= 1;
    }

    private static String keepDigitsOnly(String text) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < text.length()) {
            char ch = text.charAt(i);
            if (ch >= '0' && ch <= '9') {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }

    public static PlatformType getPlatform() {
        if (osName == null) {
            osName = System.getProperty("os.name").toLowerCase();
        }
        if (osName.contains("windows")) {
            return PlatformType.WINDOWS;
        }
        if (osName.contains("mac")) {
            return PlatformType.MACOS;
        }
        if (osName.contains("linux")) {
            return PlatformType.LINUX;
        }
        if (osName.contains("solaris") || osName.contains("sunos")) {
            return PlatformType.SOLARIS;
        }
        if (osName.contains("freebsd")) {
            return PlatformType.FREEBSD;
        }
        if (osName.contains("os/2") || osName.contains("ecomstation")) {
            return PlatformType.OS2;
        }
        if (osName.contains("haiku")) {
            return PlatformType.HAIKU;
        }
        if (osName.contains("aix")) {
            return PlatformType.AIX;
        }
        return PlatformType.UNKNOWN;
    }

    public static boolean isUnixLikePlatform() {
        PlatformType[] unixPlatforms = new PlatformType[]{PlatformType.SOLARIS, PlatformType.FREEBSD, PlatformType.AIX, PlatformType.LINUX};
        PlatformType platformType = Platform.getPlatform();
        return new HashSet<PlatformType>(Arrays.asList(unixPlatforms)).contains((Object)platformType);
    }

    public static boolean isMacOsX() {
        return Platform.getPlatform().equals((Object)PlatformType.MACOS);
    }

    public static boolean isWindows() {
        return Platform.getPlatform().equals((Object)PlatformType.WINDOWS);
    }

    public static boolean isJPackaged() {
        return StringUtils.isNotBlank(System.getProperty("jpackage.app-path"));
    }

    public static boolean isGcj() {
        String javaVmName = System.getProperty("java.vm.name");
        return javaVmName != null && javaVmName.toLowerCase().contains("gnu libgcj");
    }

    public static boolean isOpenJdk() {
        String javaVmName = System.getProperty("java.vm.name");
        return javaVmName != null && javaVmName.toLowerCase().contains("openjdk");
    }

    public static boolean isArm64() {
        return "aarch64".equals(System.getProperty("os.arch"));
    }

    public static boolean isSupportedPlatform() {
        String javaVersion;
        PlatformType pt = Platform.getPlatform();
        if (pt != PlatformType.WINDOWS && pt != PlatformType.LINUX && pt != PlatformType.MACOS) {
            return false;
        }
        if (pt != PlatformType.MACOS && pt != PlatformType.SOLARIS) {
            String arch = System.getProperty("os.arch");
            String[] archs = new String[]{"x86", "x64", "x86_64", "amd64", "i386"};
            boolean supported = false;
            String[] stringArray = archs;
            int n = archs.length;
            int n2 = 0;
            while (n2 < n) {
                String suppArch = stringArray[n2];
                if (suppArch.equals(arch)) {
                    supported = true;
                }
                ++n2;
            }
            if (!supported) {
                return false;
            }
        }
        return !(javaVersion = System.getProperty("java.version")).startsWith("1.5.") && !javaVersion.equals("1.5");
    }

    public static ImageIcon getPlatformIcon(PlatformType platformType) {
        return IconLoader.getIcon(Platform.class, "icons/" + platformType.name().toLowerCase() + ".png", 16);
    }

    public static int getJavaMajorVersion() {
        return javaMajorVersion;
    }

    public static int getJavaMinorVersion() {
        return javaMinorVersion;
    }

    public static String getJavaRevision() {
        return javaRevision;
    }

    public static boolean isBelowJava16() {
        return javaMajorVersion <= 1 && javaMinorVersion < 6;
    }

    public static boolean isBelowJava17() {
        return javaMajorVersion <= 1 && javaMinorVersion < 7;
    }

    public static boolean isBelowJava18() {
        return javaMajorVersion <= 1 && javaMinorVersion < 8;
    }

    public static boolean isBelowJava19() {
        return javaMajorVersion <= 1 && javaMinorVersion < 9;
    }

    public static boolean isInterpreted() {
        return interpreted;
    }

    public static void lowerPriority() {
        if (Platform.isWindows() && singleCore) {
            Thread.currentThread().setPriority(2);
        }
    }

    public static void normalPriority() {
        if (Platform.isWindows() && singleCore) {
            Thread.currentThread().setPriority(5);
        }
    }

    public static void yield() {
        if (Platform.isWindows() && singleCore) {
            Thread.yield();
        }
    }
}

