/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.corebounce.common.gui.AwtTools;

public class Plotter {
    private static final int GAP = 10;
    private final float norm;
    private final float min;
    private final float max;
    private final float tickX;
    private final float tickY;
    private final boolean log;
    private JFrame frame;
    private List<float[]> curves = new ArrayList<float[]>();
    private List<Color> curveColors = new ArrayList<Color>();
    private List<Point2D.Float> points = new ArrayList<Point2D.Float>();
    private List<Color> pointColors = new ArrayList<Color>();
    private List<Line2D.Float> lines = new ArrayList<Line2D.Float>();
    private List<Color> lineColors = new ArrayList<Color>();

    public Plotter(float norm, float min, float max, float tickX, float tickY, boolean log, String name) {
        this.norm = norm;
        this.min = min;
        this.max = max;
        this.tickX = tickX;
        this.tickY = tickY;
        this.log = log;
        this.frame = new JFrame(name);
        PlotPanel panel = new PlotPanel();
        panel.setPreferredSize(new Dimension(400, 400));
        this.frame.getContentPane().setLayout(new BorderLayout());
        this.frame.getContentPane().add((Component)panel, "Center");
        this.frame.pack();
        this.frame.setDefaultCloseOperation(3);
    }

    public void addCurve(float[] values, Color color) {
        this.curves.add(values);
        this.curveColors.add(color);
    }

    public void addPoint(float x, float y, Color color) {
        this.points.add(new Point2D.Float(x, y));
        this.pointColors.add(color);
    }

    public void addLine(float sx, float sy, float ex, float ey, Color color) {
        this.lines.add(new Line2D.Float(sx, sy, ex, ey));
        this.lineColors.add(color);
    }

    public void show() {
        this.frame.setVisible(true);
    }

    class PlotPanel
    extends JPanel {
        PlotPanel() {
        }

        @Override
        protected void paintComponent(Graphics g0) {
            double py;
            double px;
            Graphics2D g = (Graphics2D)g0;
            AwtTools.setupHighQuality(g);
            int width = this.getWidth() - 20;
            int height = this.getHeight() - 20;
            g.translate(0, this.getHeight());
            g.scale(1.0, -1.0);
            g.translate(10, 10);
            g.setColor(Color.lightGray);
            float maxX = ((float[])Plotter.this.curves.get(0)).length;
            float x = 0.0f;
            while (x < maxX + Plotter.this.tickX) {
                float px2 = (float)this.scaleHorz(x / maxX) * (float)width / Plotter.this.norm;
                g.draw(new Line2D.Float(px2, 0.0f, px2, height));
                x += Plotter.this.tickX;
            }
            float y = Plotter.this.min;
            while (y < Plotter.this.max + Plotter.this.tickY) {
                float py2 = (y - Plotter.this.min) * (float)height / (Plotter.this.max - Plotter.this.min);
                g.draw(new Line2D.Float(0.0f, py2, width, py2));
                y += Plotter.this.tickY;
            }
            g.setStroke(new BasicStroke(2.0f));
            int c = 0;
            while (c < Plotter.this.curves.size()) {
                float[] values = (float[])Plotter.this.curves.get(c);
                g.setColor((Color)Plotter.this.curveColors.get(c));
                px = 0.0;
                py = 0.0;
                int i = 0;
                while (i < values.length) {
                    double x2 = this.scaleHorz((double)i / (double)values.length) * (double)width;
                    double y2 = (double)(values[i] - Plotter.this.min) * (double)height / (double)(Plotter.this.max - Plotter.this.min);
                    if (i > 0) {
                        g.draw(new Line2D.Double(px, py, x2, y2));
                    }
                    px = x2;
                    py = y2;
                    ++i;
                }
                ++c;
            }
            g.setStroke(new BasicStroke(5.0f));
            int p = 0;
            while (p < Plotter.this.points.size()) {
                Point2D.Float point = (Point2D.Float)Plotter.this.points.get(p);
                g.setColor((Color)Plotter.this.pointColors.get(p));
                px = this.scaleHorz((double)point.x / (double)maxX) * (double)width;
                py = (double)(point.y - Plotter.this.min) * (double)height / (double)(Plotter.this.max - Plotter.this.min);
                g.draw(new Ellipse2D.Double(px - 6.0, py - 6.0, 12.0, 12.0));
                ++p;
            }
            g.setStroke(new BasicStroke(1.0f));
            int l = 0;
            while (l < Plotter.this.lines.size()) {
                Line2D.Float line = (Line2D.Float)Plotter.this.lines.get(l);
                g.setColor((Color)Plotter.this.lineColors.get(l));
                double sx = this.scaleHorz((double)line.x1 / (double)maxX) * (double)width;
                double sy = (double)(line.y1 - Plotter.this.min) * (double)height / (double)(Plotter.this.max - Plotter.this.min);
                double ex = this.scaleHorz((double)line.x2 / (double)maxX) * (double)width;
                double ey = (double)(line.y2 - Plotter.this.min) * (double)height / (double)(Plotter.this.max - Plotter.this.min);
                g.draw(new Line2D.Double(sx, sy, ex, ey));
                ++l;
            }
        }

        private double scaleHorz(double x) {
            if (!Plotter.this.log) {
                return x;
            }
            double base = 4.0;
            double shift = 2.6;
            x = (Math.log(x) / Math.log(base) + shift) / shift;
            return x;
        }
    }
}

