/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

import java.text.DecimalFormat;
import org.corebounce.common.utils.Platform;

public class SizeFormatter {
    public static String format(double value) {
        double divisor;
        String[] suffixes;
        if (Platform.isMacOsX() || Platform.isUnixLikePlatform()) {
            suffixes = new String[]{"B", "kB", "MB", "GB", "TB"};
            divisor = 1000.0;
        } else {
            suffixes = new String[]{"B", "KB", "MB", "GB", "TB"};
            divisor = 1024.0;
        }
        int suffixIndex = 0;
        double value0 = value;
        while (value0 >= 1300.0 && suffixIndex < suffixes.length - 1) {
            value0 /= divisor;
            ++suffixIndex;
        }
        DecimalFormat format = new DecimalFormat("#0.##");
        String result = format.format(value0) + " " + suffixes[suffixIndex];
        if (suffixIndex > 0) {
            DecimalFormat bFormat = new DecimalFormat("#,##0");
            result = String.valueOf(result) + " (" + bFormat.format((long)value) + (value > 1.0 ? " bytes)" : " byte)");
        }
        return result;
    }

    public static String cobolize(String value, int length, boolean rightAlign) {
        if (value.length() >= length) {
            return value.substring(0, length);
        }
        StringBuilder result = new StringBuilder();
        result.append(value);
        while (result.length() < length) {
            if (rightAlign) {
                result.insert(0, " ");
                continue;
            }
            result.append(" ");
        }
        return result.toString();
    }
}

