/*
 * Decompiled with CFR 0.152.
 */
package org.corebounce.common.utils;

public class ThreadLocalFlag {
    private final ThreadLocal<Boolean> target = new ThreadLocal();
    private final boolean defaultValue;

    public ThreadLocalFlag(boolean defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean get() {
        Boolean result = this.target.get();
        if (result != null) {
            return result;
        }
        return this.defaultValue;
    }

    public void set(boolean value) {
        if (value == this.defaultValue) {
            this.target.remove();
        } else {
            this.target.set(value);
        }
    }

    public boolean reset() {
        this.target.remove();
        return this.defaultValue;
    }
}

